
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Migrated STAR Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="STARDataType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="required" name="STARName"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="OriginatingPCC"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class STARDataType implements Serializable
{
    private String string;
    private String STARName;
    private String originatingPCC;
    private String orderSequenceNo;
    private String displaySequenceNo;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'STARName' attribute value.
     * 
     * @return value
     */
    public String getSTARName() {
        return STARName;
    }

    /** 
     * Set the 'STARName' attribute value.
     * 
     * @param STARName
     */
    public void setSTARName(String STARName) {
        this.STARName = STARName;
    }

    /** 
     * Get the 'OriginatingPCC' attribute value.
     * 
     * @return value
     */
    public String getOriginatingPCC() {
        return originatingPCC;
    }

    /** 
     * Set the 'OriginatingPCC' attribute value.
     * 
     * @param originatingPCC
     */
    public void setOriginatingPCC(String originatingPCC) {
        this.originatingPCC = originatingPCC;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
