
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_EventNotification">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:ProfileEventType" name="ProfileEvent"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SabreOTAEventNotification implements Serializable
{
    private ProfileEventType profileEvent;
    private Date timeStamp;
    private String requestTrackingID;

    /** 
     * Get the 'ProfileEvent' element value.
     * 
     * @return value
     */
    public ProfileEventType getProfileEvent() {
        return profileEvent;
    }

    /** 
     * Set the 'ProfileEvent' element value.
     * 
     * @param profileEvent
     */
    public void setProfileEvent(ProfileEventType profileEvent) {
        this.profileEvent = profileEvent;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
}
