
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileCreateRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:ResponseMessageType" name="ResponseMessage"/>
 *       &lt;xs:choice minOccurs="0">
 *         &lt;!-- Reference to inner class Choice -->
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="CreateDateTime"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileCreateRS implements Serializable
{
    private ResponseMessageType responseMessage;
    private Choice choice;
    private Date timeStamp;
    private Target target;
    private String version;
    private Date createDateTime;
    private String requestTrackingID;

    /** 
     * Get the 'ResponseMessage' element value.
     * 
     * @return value
     */
    public ResponseMessageType getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value.
     * 
     * @param responseMessage
     */
    public void setResponseMessage(ResponseMessageType responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:TPAIdentityType" name="Profile"/>
     *   &lt;xs:element type="ns:DupChkRSProfileInfoType" name="DuplicateCheckProfiles"/>
     *   &lt;xs:element type="ns:TemplateIdentityType" name="Template"/>
     *   &lt;xs:element type="ns:MetadataIdentityType" name="Metadata"/>
     *   &lt;xs:element type="ns:ValidatorIdentityType" name="Validator"/>
     *   &lt;xs:element type="ns:AssociationIdentityType" name="Association"/>
     *   &lt;xs:element type="ns:FilterIdentityType" name="Filter"/>
     *   &lt;xs:element type="ns:FormatIdentityType" name="Format"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int PROFILE_CHOICE = 0;
        private static final int DUPLICATE_CHECK_PROFILES_CHOICE = 1;
        private static final int TEMPLATE_CHOICE = 2;
        private static final int METADATA_CHOICE = 3;
        private static final int VALIDATOR_CHOICE = 4;
        private static final int ASSOCIATION_CHOICE = 5;
        private static final int FILTER_CHOICE = 6;
        private static final int FORMAT_CHOICE = 7;
        private TPAIdentityType profile;
        private DupChkRSProfileInfoType duplicateCheckProfiles;
        private TemplateIdentityType template;
        private MetadataIdentityType metadata;
        private ValidatorIdentityType validator;
        private AssociationIdentityType association;
        private FilterIdentityType filter;
        private FormatIdentityType format;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Profile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifProfile() {
            return choiceSelect == PROFILE_CHOICE;
        }

        /** 
         * Get the 'Profile' element value. *** SABRE ADDED *** Profiles  Response
         * 
         * @return value
         */
        public TPAIdentityType getProfile() {
            return profile;
        }

        /** 
         * Set the 'Profile' element value. *** SABRE ADDED *** Profiles  Response
         * 
         * @param profile
         */
        public void setProfile(TPAIdentityType profile) {
            setChoiceSelect(PROFILE_CHOICE);
            this.profile = profile;
        }

        /** 
         * Check if DuplicateCheckProfiles is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDuplicateCheckProfiles() {
            return choiceSelect == DUPLICATE_CHECK_PROFILES_CHOICE;
        }

        /** 
         * Get the 'DuplicateCheckProfiles' element value. *** SABRE ADDED *** If ProfileDuplicateCheck is enabled and duplicates are found then that info is returned thru this subject area 
         * 
         * @return value
         */
        public DupChkRSProfileInfoType getDuplicateCheckProfiles() {
            return duplicateCheckProfiles;
        }

        /** 
         * Set the 'DuplicateCheckProfiles' element value. *** SABRE ADDED *** If ProfileDuplicateCheck is enabled and duplicates are found then that info is returned thru this subject area 
         * 
         * @param duplicateCheckProfiles
         */
        public void setDuplicateCheckProfiles(
                DupChkRSProfileInfoType duplicateCheckProfiles) {
            setChoiceSelect(DUPLICATE_CHECK_PROFILES_CHOICE);
            this.duplicateCheckProfiles = duplicateCheckProfiles;
        }

        /** 
         * Check if Template is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTemplate() {
            return choiceSelect == TEMPLATE_CHOICE;
        }

        /** 
         * Get the 'Template' element value. *** SABRE ADDED *** Templates  Response
         * 
         * @return value
         */
        public TemplateIdentityType getTemplate() {
            return template;
        }

        /** 
         * Set the 'Template' element value. *** SABRE ADDED *** Templates  Response
         * 
         * @param template
         */
        public void setTemplate(TemplateIdentityType template) {
            setChoiceSelect(TEMPLATE_CHOICE);
            this.template = template;
        }

        /** 
         * Check if Metadata is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMetadata() {
            return choiceSelect == METADATA_CHOICE;
        }

        /** 
         * Get the 'Metadata' element value. *** SABRE ADDED *** Metadatas Response
         * 
         * @return value
         */
        public MetadataIdentityType getMetadata() {
            return metadata;
        }

        /** 
         * Set the 'Metadata' element value. *** SABRE ADDED *** Metadatas Response
         * 
         * @param metadata
         */
        public void setMetadata(MetadataIdentityType metadata) {
            setChoiceSelect(METADATA_CHOICE);
            this.metadata = metadata;
        }

        /** 
         * Check if Validator is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifValidator() {
            return choiceSelect == VALIDATOR_CHOICE;
        }

        /** 
         * Get the 'Validator' element value. *** SABRE ADDED *** Validators Response
         * 
         * @return value
         */
        public ValidatorIdentityType getValidator() {
            return validator;
        }

        /** 
         * Set the 'Validator' element value. *** SABRE ADDED *** Validators Response
         * 
         * @param validator
         */
        public void setValidator(ValidatorIdentityType validator) {
            setChoiceSelect(VALIDATOR_CHOICE);
            this.validator = validator;
        }

        /** 
         * Check if Association is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAssociation() {
            return choiceSelect == ASSOCIATION_CHOICE;
        }

        /** 
         * Get the 'Association' element value. *** SABRE ADDED *** Annotations Response
         * 
         * @return value
         */
        public AssociationIdentityType getAssociation() {
            return association;
        }

        /** 
         * Set the 'Association' element value. *** SABRE ADDED *** Annotations Response
         * 
         * @param association
         */
        public void setAssociation(AssociationIdentityType association) {
            setChoiceSelect(ASSOCIATION_CHOICE);
            this.association = association;
        }

        /** 
         * Check if Filter is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFilter() {
            return choiceSelect == FILTER_CHOICE;
        }

        /** 
         * Get the 'Filter' element value. *** SABRE ADDED *** Filter Response 
         * 
         * @return value
         */
        public FilterIdentityType getFilter() {
            return filter;
        }

        /** 
         * Set the 'Filter' element value. *** SABRE ADDED *** Filter Response 
         * 
         * @param filter
         */
        public void setFilter(FilterIdentityType filter) {
            setChoiceSelect(FILTER_CHOICE);
            this.filter = filter;
        }

        /** 
         * Check if Format is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFormat() {
            return choiceSelect == FORMAT_CHOICE;
        }

        /** 
         * Get the 'Format' element value. *** SABRE ADDED *** Format Response 
         * 
         * @return value
         */
        public FormatIdentityType getFormat() {
            return format;
        }

        /** 
         * Set the 'Format' element value. *** SABRE ADDED *** Format Response 
         * 
         * @param format
         */
        public void setFormat(FormatIdentityType format) {
            setChoiceSelect(FORMAT_CHOICE);
            this.format = format;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
