
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Response to Sabre_OTA_ProfileDataMgmtRQ
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileDataMgmtRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:ResponseMessageType" name="ResponseMessage"/>
 *       &lt;xs:choice minOccurs="0">
 *         &lt;!-- Reference to inner class Choice -->
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileDataMgmtRS implements Serializable
{
    private ResponseMessageType responseMessage;
    private Choice choice;
    private Date timeStamp;
    private Target target;
    private String version;
    private String requestTrackingID;

    /** 
     * Get the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @return value
     */
    public ResponseMessageType getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @param responseMessage
     */
    public void setResponseMessage(ResponseMessageType responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:MoveToDomainRSType" name="MoveDomainObject"/>
     *   &lt;xs:element type="ns:MoveDomainRSType" name="MoveDomain"/>
     *   &lt;xs:element type="ns:CopyToDomainRSType" name="CopyDomainObject"/>
     *   &lt;xs:element type="ns:StatusOfMoveDomainRSType" name="StatusOfMoveDomain"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int MOVE_DOMAIN_OBJECT_CHOICE = 0;
        private static final int MOVE_DOMAIN_CHOICE = 1;
        private static final int COPY_DOMAIN_OBJECT_CHOICE = 2;
        private static final int STATUS_OF_MOVE_DOMAIN_CHOICE = 3;
        private MoveToDomainRSType moveDomainObject;
        private MoveDomainRSType moveDomain;
        private CopyToDomainRSType copyDomainObject;
        private StatusOfMoveDomainRSType statusOfMoveDomain;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if MoveDomainObject is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMoveDomainObject() {
            return choiceSelect == MOVE_DOMAIN_OBJECT_CHOICE;
        }

        /** 
         * Get the 'MoveDomainObject' element value. *** SABRE ADDED *** Used to move Profiles/Templates across PCC with branch access
         * 
         * @return value
         */
        public MoveToDomainRSType getMoveDomainObject() {
            return moveDomainObject;
        }

        /** 
         * Set the 'MoveDomainObject' element value. *** SABRE ADDED *** Used to move Profiles/Templates across PCC with branch access
         * 
         * @param moveDomainObject
         */
        public void setMoveDomainObject(MoveToDomainRSType moveDomainObject) {
            setChoiceSelect(MOVE_DOMAIN_OBJECT_CHOICE);
            this.moveDomainObject = moveDomainObject;
        }

        /** 
         * Check if MoveDomain is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMoveDomain() {
            return choiceSelect == MOVE_DOMAIN_CHOICE;
        }

        /** 
         * Get the 'MoveDomain' element value. *** SABRE ADDED *** Used to move all data across PCC with branch access
         * 
         * @return value
         */
        public MoveDomainRSType getMoveDomain() {
            return moveDomain;
        }

        /** 
         * Set the 'MoveDomain' element value. *** SABRE ADDED *** Used to move all data across PCC with branch access
         * 
         * @param moveDomain
         */
        public void setMoveDomain(MoveDomainRSType moveDomain) {
            setChoiceSelect(MOVE_DOMAIN_CHOICE);
            this.moveDomain = moveDomain;
        }

        /** 
         * Check if CopyDomainObject is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCopyDomainObject() {
            return choiceSelect == COPY_DOMAIN_OBJECT_CHOICE;
        }

        /** 
         * Get the 'CopyDomainObject' element value. *** SABRE ADDED *** Used to copy Templates across PCC with branch access
         * 
         * @return value
         */
        public CopyToDomainRSType getCopyDomainObject() {
            return copyDomainObject;
        }

        /** 
         * Set the 'CopyDomainObject' element value. *** SABRE ADDED *** Used to copy Templates across PCC with branch access
         * 
         * @param copyDomainObject
         */
        public void setCopyDomainObject(CopyToDomainRSType copyDomainObject) {
            setChoiceSelect(COPY_DOMAIN_OBJECT_CHOICE);
            this.copyDomainObject = copyDomainObject;
        }

        /** 
         * Check if StatusOfMoveDomain is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifStatusOfMoveDomain() {
            return choiceSelect == STATUS_OF_MOVE_DOMAIN_CHOICE;
        }

        /** 
         * Get the 'StatusOfMoveDomain' element value.
         * 
         * @return value
         */
        public StatusOfMoveDomainRSType getStatusOfMoveDomain() {
            return statusOfMoveDomain;
        }

        /** 
         * Set the 'StatusOfMoveDomain' element value.
         * 
         * @param statusOfMoveDomain
         */
        public void setStatusOfMoveDomain(
                StatusOfMoveDomainRSType statusOfMoveDomain) {
            setChoiceSelect(STATUS_OF_MOVE_DOMAIN_CHOICE);
            this.statusOfMoveDomain = statusOfMoveDomain;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
