
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * 
 Schemas to handle Admin functionality associated with Profiles

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileDataSrvRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:RetrieveCustomFieldCodesType" name="RetrieveCustomFieldCodes"/>
 *       &lt;xs:element type="ns:CreateCustomFieldCodeType" name="CreateCustomFieldCode"/>
 *       &lt;xs:element type="ns:RestorePasswordType" name="RestorePassword"/>
 *       &lt;xs:element type="ns:ValidateSecurityAnswersType" name="ValidateSecurityAnswers"/>
 *       &lt;xs:element type="ns:DictionaryOperationType" name="DictionaryOperation"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileDataSrvRQ implements Serializable
{
    private int choiceSelect = -1;
    private static final int RETRIEVE_CUSTOM_FIELD_CODES_CHOICE = 0;
    private static final int CREATE_CUSTOM_FIELD_CODE_CHOICE = 1;
    private static final int RESTORE_PASSWORD_CHOICE = 2;
    private static final int VALIDATE_SECURITY_ANSWERS_CHOICE = 3;
    private static final int DICTIONARY_OPERATION_CHOICE = 4;
    private RetrieveCustomFieldCodesType retrieveCustomFieldCodes;
    private CreateCustomFieldCodeType createCustomFieldCode;
    private RestorePasswordType restorePassword;
    private ValidateSecurityAnswersType validateSecurityAnswers;
    private DictionaryOperationType dictionaryOperation;
    private Date timeStamp;
    private Target target;
    private String version;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if RetrieveCustomFieldCodes is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRetrieveCustomFieldCodes() {
        return choiceSelect == RETRIEVE_CUSTOM_FIELD_CODES_CHOICE;
    }

    /** 
     * Get the 'RetrieveCustomFieldCodes' element value. *** SABRE ADDED *** Retrieve Custom Filed Codes associated with a DomainID
     * 
     * @return value
     */
    public RetrieveCustomFieldCodesType getRetrieveCustomFieldCodes() {
        return retrieveCustomFieldCodes;
    }

    /** 
     * Set the 'RetrieveCustomFieldCodes' element value. *** SABRE ADDED *** Retrieve Custom Filed Codes associated with a DomainID
     * 
     * @param retrieveCustomFieldCodes
     */
    public void setRetrieveCustomFieldCodes(
            RetrieveCustomFieldCodesType retrieveCustomFieldCodes) {
        setChoiceSelect(RETRIEVE_CUSTOM_FIELD_CODES_CHOICE);
        this.retrieveCustomFieldCodes = retrieveCustomFieldCodes;
    }

    /** 
     * Check if CreateCustomFieldCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCreateCustomFieldCode() {
        return choiceSelect == CREATE_CUSTOM_FIELD_CODE_CHOICE;
    }

    /** 
     * Get the 'CreateCustomFieldCode' element value. *** SABRE ADDED *** Create Custom Filed Codes associated with a DomainID
     * 
     * @return value
     */
    public CreateCustomFieldCodeType getCreateCustomFieldCode() {
        return createCustomFieldCode;
    }

    /** 
     * Set the 'CreateCustomFieldCode' element value. *** SABRE ADDED *** Create Custom Filed Codes associated with a DomainID
     * 
     * @param createCustomFieldCode
     */
    public void setCreateCustomFieldCode(
            CreateCustomFieldCodeType createCustomFieldCode) {
        setChoiceSelect(CREATE_CUSTOM_FIELD_CODE_CHOICE);
        this.createCustomFieldCode = createCustomFieldCode;
    }

    /** 
     * Check if RestorePassword is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRestorePassword() {
        return choiceSelect == RESTORE_PASSWORD_CHOICE;
    }

    /** 
     * Get the 'RestorePassword' element value. *** SABRE ADDED *** Used to restore passwords when they forgot password
     * 
     * @return value
     */
    public RestorePasswordType getRestorePassword() {
        return restorePassword;
    }

    /** 
     * Set the 'RestorePassword' element value. *** SABRE ADDED *** Used to restore passwords when they forgot password
     * 
     * @param restorePassword
     */
    public void setRestorePassword(RestorePasswordType restorePassword) {
        setChoiceSelect(RESTORE_PASSWORD_CHOICE);
        this.restorePassword = restorePassword;
    }

    /** 
     * Check if ValidateSecurityAnswers is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifValidateSecurityAnswers() {
        return choiceSelect == VALIDATE_SECURITY_ANSWERS_CHOICE;
    }

    /** 
     * Get the 'ValidateSecurityAnswers' element value. *** SABRE ADDED *** Used to Validate Security questions in case of forgot password
     * 
     * @return value
     */
    public ValidateSecurityAnswersType getValidateSecurityAnswers() {
        return validateSecurityAnswers;
    }

    /** 
     * Set the 'ValidateSecurityAnswers' element value. *** SABRE ADDED *** Used to Validate Security questions in case of forgot password
     * 
     * @param validateSecurityAnswers
     */
    public void setValidateSecurityAnswers(
            ValidateSecurityAnswersType validateSecurityAnswers) {
        setChoiceSelect(VALIDATE_SECURITY_ANSWERS_CHOICE);
        this.validateSecurityAnswers = validateSecurityAnswers;
    }

    /** 
     * Check if DictionaryOperation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDictionaryOperation() {
        return choiceSelect == DICTIONARY_OPERATION_CHOICE;
    }

    /** 
     * Get the 'DictionaryOperation' element value. *** SABRE ADDED *** Used to Create/Read/Update/Delete/Copy Dictionary
     * 
     * @return value
     */
    public DictionaryOperationType getDictionaryOperation() {
        return dictionaryOperation;
    }

    /** 
     * Set the 'DictionaryOperation' element value. *** SABRE ADDED *** Used to Create/Read/Update/Delete/Copy Dictionary
     * 
     * @param dictionaryOperation
     */
    public void setDictionaryOperation(
            DictionaryOperationType dictionaryOperation) {
        setChoiceSelect(DICTIONARY_OPERATION_CHOICE);
        this.dictionaryOperation = dictionaryOperation;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
