
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Response to Sabre_OTA_ProfileDataSrvRQ
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileDataSrvRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:ResponseMessageType" name="ResponseMessage"/>
 *       &lt;xs:choice minOccurs="0">
 *         &lt;!-- Reference to inner class Choice -->
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileDataSrvRS implements Serializable
{
    private ResponseMessageType responseMessage;
    private Choice choice;
    private Date timeStamp;
    private Target target;
    private String version;
    private String requestTrackingID;

    /** 
     * Get the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @return value
     */
    public ResponseMessageType getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @param responseMessage
     */
    public void setResponseMessage(ResponseMessageType responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:RetrieveCustomFieldCodesRSType" name="RetrieveCustomFieldCodes"/>
     *   &lt;xs:element type="ns:CreateCustomFieldCodeRSType" name="CreateCustomFieldCode"/>
     *   &lt;xs:element type="ns:RestorePasswordRSType" name="RestorePassword"/>
     *   &lt;xs:element type="ns:ValidateSecurityAnswersRSType" name="ValidateSecurityAnswers"/>
     *   &lt;xs:element type="ns:DictionaryType" name="ReadDictionaryData"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int RETRIEVE_CUSTOM_FIELD_CODES_CHOICE = 0;
        private static final int CREATE_CUSTOM_FIELD_CODE_CHOICE = 1;
        private static final int RESTORE_PASSWORD_CHOICE = 2;
        private static final int VALIDATE_SECURITY_ANSWERS_CHOICE = 3;
        private static final int READ_DICTIONARY_DATA_CHOICE = 4;
        private RetrieveCustomFieldCodesRSType retrieveCustomFieldCodes;
        private CreateCustomFieldCodeRSType createCustomFieldCode;
        private RestorePasswordRSType restorePassword;
        private ValidateSecurityAnswersRSType validateSecurityAnswers;
        private DictionaryType readDictionaryData;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if RetrieveCustomFieldCodes is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRetrieveCustomFieldCodes() {
            return choiceSelect == RETRIEVE_CUSTOM_FIELD_CODES_CHOICE;
        }

        /** 
         * Get the 'RetrieveCustomFieldCodes' element value. *** SABRE ADDED *** Response for RetrieveCustomFieldCodes
         * 
         * @return value
         */
        public RetrieveCustomFieldCodesRSType getRetrieveCustomFieldCodes() {
            return retrieveCustomFieldCodes;
        }

        /** 
         * Set the 'RetrieveCustomFieldCodes' element value. *** SABRE ADDED *** Response for RetrieveCustomFieldCodes
         * 
         * @param retrieveCustomFieldCodes
         */
        public void setRetrieveCustomFieldCodes(
                RetrieveCustomFieldCodesRSType retrieveCustomFieldCodes) {
            setChoiceSelect(RETRIEVE_CUSTOM_FIELD_CODES_CHOICE);
            this.retrieveCustomFieldCodes = retrieveCustomFieldCodes;
        }

        /** 
         * Check if CreateCustomFieldCode is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCreateCustomFieldCode() {
            return choiceSelect == CREATE_CUSTOM_FIELD_CODE_CHOICE;
        }

        /** 
         * Get the 'CreateCustomFieldCode' element value. *** SABRE ADDED *** Response for RetrieveCustomFieldCodes
         * 
         * @return value
         */
        public CreateCustomFieldCodeRSType getCreateCustomFieldCode() {
            return createCustomFieldCode;
        }

        /** 
         * Set the 'CreateCustomFieldCode' element value. *** SABRE ADDED *** Response for RetrieveCustomFieldCodes
         * 
         * @param createCustomFieldCode
         */
        public void setCreateCustomFieldCode(
                CreateCustomFieldCodeRSType createCustomFieldCode) {
            setChoiceSelect(CREATE_CUSTOM_FIELD_CODE_CHOICE);
            this.createCustomFieldCode = createCustomFieldCode;
        }

        /** 
         * Check if RestorePassword is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRestorePassword() {
            return choiceSelect == RESTORE_PASSWORD_CHOICE;
        }

        /** 
         * Get the 'RestorePassword' element value. *** SABRE ADDED *** Response for Password Restore
         * 
         * @return value
         */
        public RestorePasswordRSType getRestorePassword() {
            return restorePassword;
        }

        /** 
         * Set the 'RestorePassword' element value. *** SABRE ADDED *** Response for Password Restore
         * 
         * @param restorePassword
         */
        public void setRestorePassword(RestorePasswordRSType restorePassword) {
            setChoiceSelect(RESTORE_PASSWORD_CHOICE);
            this.restorePassword = restorePassword;
        }

        /** 
         * Check if ValidateSecurityAnswers is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifValidateSecurityAnswers() {
            return choiceSelect == VALIDATE_SECURITY_ANSWERS_CHOICE;
        }

        /** 
         * Get the 'ValidateSecurityAnswers' element value. *** SABRE ADDED *** Response for ValidateSecurityAnswers
         * 
         * @return value
         */
        public ValidateSecurityAnswersRSType getValidateSecurityAnswers() {
            return validateSecurityAnswers;
        }

        /** 
         * Set the 'ValidateSecurityAnswers' element value. *** SABRE ADDED *** Response for ValidateSecurityAnswers
         * 
         * @param validateSecurityAnswers
         */
        public void setValidateSecurityAnswers(
                ValidateSecurityAnswersRSType validateSecurityAnswers) {
            setChoiceSelect(VALIDATE_SECURITY_ANSWERS_CHOICE);
            this.validateSecurityAnswers = validateSecurityAnswers;
        }

        /** 
         * Check if ReadDictionaryData is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifReadDictionaryData() {
            return choiceSelect == READ_DICTIONARY_DATA_CHOICE;
        }

        /** 
         * Get the 'ReadDictionaryData' element value. *** SABRE ADDED *** Defines the response for Read Dictionary Request
         * 
         * @return value
         */
        public DictionaryType getReadDictionaryData() {
            return readDictionaryData;
        }

        /** 
         * Set the 'ReadDictionaryData' element value. *** SABRE ADDED *** Defines the response for Read Dictionary Request
         * 
         * @param readDictionaryData
         */
        public void setReadDictionaryData(DictionaryType readDictionaryData) {
            setChoiceSelect(READ_DICTIONARY_DATA_CHOICE);
            this.readDictionaryData = readDictionaryData;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
