
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Delete request for Profile

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileDeleteRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:DeleteType" name="Delete"/>
 *         &lt;xs:element type="ns:RestoreType" name="Restore"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:AccessInfoType" name="DeleteAccessInfo" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileDeleteRQ implements Serializable
{
    private int choiceSelect = -1;
    private static final int DELETE_CHOICE = 0;
    private static final int RESTORE_CHOICE = 1;
    private DeleteType delete;
    private RestoreType restore;
    private AccessInfoType deleteAccessInfo;
    private Date timeStamp;
    private Target target;
    private String version;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Delete is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDelete() {
        return choiceSelect == DELETE_CHOICE;
    }

    /** 
     * Get the 'Delete' element value. *** SABRE ADDED *** Delete Profiles
     * 
     * @return value
     */
    public DeleteType getDelete() {
        return delete;
    }

    /** 
     * Set the 'Delete' element value. *** SABRE ADDED *** Delete Profiles
     * 
     * @param delete
     */
    public void setDelete(DeleteType delete) {
        setChoiceSelect(DELETE_CHOICE);
        this.delete = delete;
    }

    /** 
     * Check if Restore is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRestore() {
        return choiceSelect == RESTORE_CHOICE;
    }

    /** 
     * Get the 'Restore' element value. *** SABRE ADDED *** Restore deleted  Profiles
     * 
     * @return value
     */
    public RestoreType getRestore() {
        return restore;
    }

    /** 
     * Set the 'Restore' element value. *** SABRE ADDED *** Restore deleted  Profiles
     * 
     * @param restore
     */
    public void setRestore(RestoreType restore) {
        setChoiceSelect(RESTORE_CHOICE);
        this.restore = restore;
    }

    /** 
     * Get the 'DeleteAccessInfo' element value.
     * 
     * @return value
     */
    public AccessInfoType getDeleteAccessInfo() {
        return deleteAccessInfo;
    }

    /** 
     * Set the 'DeleteAccessInfo' element value.
     * 
     * @param deleteAccessInfo
     */
    public void setDeleteAccessInfo(AccessInfoType deleteAccessInfo) {
        this.deleteAccessInfo = deleteAccessInfo;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
