
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 *  Profile History Data reqquest	
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileHistoryRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:HistoryCriteriaType" name="Criteria" minOccurs="0"/>
 *       &lt;xs:element type="ns:HistoryProfileReadType" name="Profile"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileHistoryRQ implements Serializable
{
    private HistoryCriteriaType criteria;
    private HistoryProfileReadType profile;
    private Date timeStamp;
    private Target target;
    private String version;

    /** 
     * Get the 'Criteria' element value.
     * 
     * @return value
     */
    public HistoryCriteriaType getCriteria() {
        return criteria;
    }

    /** 
     * Set the 'Criteria' element value.
     * 
     * @param criteria
     */
    public void setCriteria(HistoryCriteriaType criteria) {
        this.criteria = criteria;
    }

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public HistoryProfileReadType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(HistoryProfileReadType profile) {
        this.profile = profile;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
