
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * 
 A proprietary message, which requests a server to search using various criteria and return either a customer profile if only one found, or a list of matching customer profiles

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileSearchRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:ProfileSearchCriteriaType" name="ProfileSearchCriteria"/>
 *         &lt;xs:element type="ns:ProfileCountCriteriaType" name="ProfileCountCriteria"/>
 *         &lt;xs:element type="ns:TemplateSearchCriteriaType" name="TemplateSearchCriteria"/>
 *         &lt;xs:element type="ns:TemplateSearchCriteriaType" name="TemplateCountCriteria"/>
 *         &lt;xs:element type="ns:AssociationSearchCriteriaType" name="AssociationSearchCriteria"/>
 *         &lt;xs:element type="ns:FilterSearchCriteriaType" name="FilterSearchCriteria"/>
 *         &lt;xs:element type="ns:FormatSearchCriteriaType" name="FormatSearchCriteria"/>
 *         &lt;xs:element name="AllianceProfileSearchCriteria">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element name="Traveler">
 *                 &lt;xs:complexType>
 *                   &lt;xs:attribute type="xs:string" use="required" name="GivenName"/>
 *                   &lt;xs:attribute type="xs:string" use="required" name="SurName"/>
 *                 &lt;/xs:complexType>
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:ValidatorSearchCriteriaType" name="ValidatorSearchCriteria"/>
 *         &lt;xs:element type="ns:MetadataSearchCriteriaType" name="MetadataSearchCriteria"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:AccessInfoType" name="SearchAccessInfo" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileSearchRQ implements Serializable
{
    private int choiceSelect = -1;
    private static final int PROFILE_SEARCH_CRITERIA_CHOICE = 0;
    private static final int PROFILE_COUNT_CRITERIA_CHOICE = 1;
    private static final int TEMPLATE_SEARCH_CRITERIA_CHOICE = 2;
    private static final int TEMPLATE_COUNT_CRITERIA_CHOICE = 3;
    private static final int ASSOCIATION_SEARCH_CRITERIA_CHOICE = 4;
    private static final int FILTER_SEARCH_CRITERIA_CHOICE = 5;
    private static final int FORMAT_SEARCH_CRITERIA_CHOICE = 6;
    private static final int ALLIANCE_PROFILE_SEARCH_CRITERIA_CHOICE = 7;
    private static final int VALIDATOR_SEARCH_CRITERIA_CHOICE = 8;
    private static final int METADATA_SEARCH_CRITERIA_CHOICE = 9;
    private ProfileSearchCriteriaType profileSearchCriteria;
    private ProfileCountCriteriaType profileCountCriteria;
    private TemplateSearchCriteriaType templateSearchCriteria;
    private TemplateSearchCriteriaType templateCountCriteria;
    private AssociationSearchCriteriaType associationSearchCriteria;
    private FilterSearchCriteriaType filterSearchCriteria;
    private FormatSearchCriteriaType formatSearchCriteria;
    private String allianceProfileSearchCriteriaTravelerGivenName;
    private String allianceProfileSearchCriteriaTravelerSurName;
    private ValidatorSearchCriteriaType validatorSearchCriteria;
    private MetadataSearchCriteriaType metadataSearchCriteria;
    private AccessInfoType searchAccessInfo;
    private Date timeStamp;
    private Target target;
    private String version;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ProfileSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfileSearchCriteria() {
        return choiceSelect == PROFILE_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'ProfileSearchCriteria' element value. *** SABRE ADDED *** Different type of Profile searches
     * 
     * @return value
     */
    public ProfileSearchCriteriaType getProfileSearchCriteria() {
        return profileSearchCriteria;
    }

    /** 
     * Set the 'ProfileSearchCriteria' element value. *** SABRE ADDED *** Different type of Profile searches
     * 
     * @param profileSearchCriteria
     */
    public void setProfileSearchCriteria(
            ProfileSearchCriteriaType profileSearchCriteria) {
        setChoiceSelect(PROFILE_SEARCH_CRITERIA_CHOICE);
        this.profileSearchCriteria = profileSearchCriteria;
    }

    /** 
     * Check if ProfileCountCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfileCountCriteria() {
        return choiceSelect == PROFILE_COUNT_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'ProfileCountCriteria' element value. *** Deprecated ***
     * 
     * @return value
     */
    public ProfileCountCriteriaType getProfileCountCriteria() {
        return profileCountCriteria;
    }

    /** 
     * Set the 'ProfileCountCriteria' element value. *** Deprecated ***
     * 
     * @param profileCountCriteria
     */
    public void setProfileCountCriteria(
            ProfileCountCriteriaType profileCountCriteria) {
        setChoiceSelect(PROFILE_COUNT_CRITERIA_CHOICE);
        this.profileCountCriteria = profileCountCriteria;
    }

    /** 
     * Check if TemplateSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemplateSearchCriteria() {
        return choiceSelect == TEMPLATE_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'TemplateSearchCriteria' element value. *** SABRE ADDED *** Different type of Template searches
     * 
     * @return value
     */
    public TemplateSearchCriteriaType getTemplateSearchCriteria() {
        return templateSearchCriteria;
    }

    /** 
     * Set the 'TemplateSearchCriteria' element value. *** SABRE ADDED *** Different type of Template searches
     * 
     * @param templateSearchCriteria
     */
    public void setTemplateSearchCriteria(
            TemplateSearchCriteriaType templateSearchCriteria) {
        setChoiceSelect(TEMPLATE_SEARCH_CRITERIA_CHOICE);
        this.templateSearchCriteria = templateSearchCriteria;
    }

    /** 
     * Check if TemplateCountCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemplateCountCriteria() {
        return choiceSelect == TEMPLATE_COUNT_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'TemplateCountCriteria' element value. *** SABRE ADDED *** Different type of Template counts
     * 
     * @return value
     */
    public TemplateSearchCriteriaType getTemplateCountCriteria() {
        return templateCountCriteria;
    }

    /** 
     * Set the 'TemplateCountCriteria' element value. *** SABRE ADDED *** Different type of Template counts
     * 
     * @param templateCountCriteria
     */
    public void setTemplateCountCriteria(
            TemplateSearchCriteriaType templateCountCriteria) {
        setChoiceSelect(TEMPLATE_COUNT_CRITERIA_CHOICE);
        this.templateCountCriteria = templateCountCriteria;
    }

    /** 
     * Check if AssociationSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociationSearchCriteria() {
        return choiceSelect == ASSOCIATION_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'AssociationSearchCriteria' element value. *** SABRE ADDED *** Different type of Association searches
     * 
     * @return value
     */
    public AssociationSearchCriteriaType getAssociationSearchCriteria() {
        return associationSearchCriteria;
    }

    /** 
     * Set the 'AssociationSearchCriteria' element value. *** SABRE ADDED *** Different type of Association searches
     * 
     * @param associationSearchCriteria
     */
    public void setAssociationSearchCriteria(
            AssociationSearchCriteriaType associationSearchCriteria) {
        setChoiceSelect(ASSOCIATION_SEARCH_CRITERIA_CHOICE);
        this.associationSearchCriteria = associationSearchCriteria;
    }

    /** 
     * Check if FilterSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFilterSearchCriteria() {
        return choiceSelect == FILTER_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'FilterSearchCriteria' element value. *** SABRE ADDED *** Different type of Filter searches
     * 
     * @return value
     */
    public FilterSearchCriteriaType getFilterSearchCriteria() {
        return filterSearchCriteria;
    }

    /** 
     * Set the 'FilterSearchCriteria' element value. *** SABRE ADDED *** Different type of Filter searches
     * 
     * @param filterSearchCriteria
     */
    public void setFilterSearchCriteria(
            FilterSearchCriteriaType filterSearchCriteria) {
        setChoiceSelect(FILTER_SEARCH_CRITERIA_CHOICE);
        this.filterSearchCriteria = filterSearchCriteria;
    }

    /** 
     * Check if FormatSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFormatSearchCriteria() {
        return choiceSelect == FORMAT_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'FormatSearchCriteria' element value. *** SABRE ADDED *** Different type of Format searches
     * 
     * @return value
     */
    public FormatSearchCriteriaType getFormatSearchCriteria() {
        return formatSearchCriteria;
    }

    /** 
     * Set the 'FormatSearchCriteria' element value. *** SABRE ADDED *** Different type of Format searches
     * 
     * @param formatSearchCriteria
     */
    public void setFormatSearchCriteria(
            FormatSearchCriteriaType formatSearchCriteria) {
        setChoiceSelect(FORMAT_SEARCH_CRITERIA_CHOICE);
        this.formatSearchCriteria = formatSearchCriteria;
    }

    /** 
     * Check if AllianceProfileSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllianceProfileSearchCriteria() {
        return choiceSelect == ALLIANCE_PROFILE_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'GivenName' attribute value. First name
     * 
     * @return value
     */
    public String getAllianceProfileSearchCriteriaTravelerGivenName() {
        return allianceProfileSearchCriteriaTravelerGivenName;
    }

    /** 
     * Set the 'GivenName' attribute value. First name
     * 
     * @param allianceProfileSearchCriteriaTravelerGivenName
     */
    public void setAllianceProfileSearchCriteriaTravelerGivenName(
            String allianceProfileSearchCriteriaTravelerGivenName) {
        setChoiceSelect(ALLIANCE_PROFILE_SEARCH_CRITERIA_CHOICE);
        this.allianceProfileSearchCriteriaTravelerGivenName = allianceProfileSearchCriteriaTravelerGivenName;
    }

    /** 
     * Get the 'SurName' attribute value. Last name
     * 
     * @return value
     */
    public String getAllianceProfileSearchCriteriaTravelerSurName() {
        return allianceProfileSearchCriteriaTravelerSurName;
    }

    /** 
     * Set the 'SurName' attribute value. Last name
     * 
     * @param allianceProfileSearchCriteriaTravelerSurName
     */
    public void setAllianceProfileSearchCriteriaTravelerSurName(
            String allianceProfileSearchCriteriaTravelerSurName) {
        setChoiceSelect(ALLIANCE_PROFILE_SEARCH_CRITERIA_CHOICE);
        this.allianceProfileSearchCriteriaTravelerSurName = allianceProfileSearchCriteriaTravelerSurName;
    }

    /** 
     * Check if ValidatorSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifValidatorSearchCriteria() {
        return choiceSelect == VALIDATOR_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'ValidatorSearchCriteria' element value. *** SABRE ADDED *** Different type of Validator searches
     * 
     * @return value
     */
    public ValidatorSearchCriteriaType getValidatorSearchCriteria() {
        return validatorSearchCriteria;
    }

    /** 
     * Set the 'ValidatorSearchCriteria' element value. *** SABRE ADDED *** Different type of Validator searches
     * 
     * @param validatorSearchCriteria
     */
    public void setValidatorSearchCriteria(
            ValidatorSearchCriteriaType validatorSearchCriteria) {
        setChoiceSelect(VALIDATOR_SEARCH_CRITERIA_CHOICE);
        this.validatorSearchCriteria = validatorSearchCriteria;
    }

    /** 
     * Check if MetadataSearchCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMetadataSearchCriteria() {
        return choiceSelect == METADATA_SEARCH_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'MetadataSearchCriteria' element value. *** SABRE ADDED *** Different type of Metadata searches
     * 
     * @return value
     */
    public MetadataSearchCriteriaType getMetadataSearchCriteria() {
        return metadataSearchCriteria;
    }

    /** 
     * Set the 'MetadataSearchCriteria' element value. *** SABRE ADDED *** Different type of Metadata searches
     * 
     * @param metadataSearchCriteria
     */
    public void setMetadataSearchCriteria(
            MetadataSearchCriteriaType metadataSearchCriteria) {
        setChoiceSelect(METADATA_SEARCH_CRITERIA_CHOICE);
        this.metadataSearchCriteria = metadataSearchCriteria;
    }

    /** 
     * Get the 'SearchAccessInfo' element value.
     * 
     * @return value
     */
    public AccessInfoType getSearchAccessInfo() {
        return searchAccessInfo;
    }

    /** 
     * Set the 'SearchAccessInfo' element value.
     * 
     * @param searchAccessInfo
     */
    public void setSearchAccessInfo(AccessInfoType searchAccessInfo) {
        this.searchAccessInfo = searchAccessInfo;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
