
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileToPNRRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:FilterPathType" name="FilterPath"/>
 *         &lt;xs:element type="ns:ProfilePathType" name="ProfilePath"/>
 *         &lt;xs:element type="ns:TemporaryFilterPathType" name="TemporaryFilterPath"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:ExternalDataType" name="ExternalData" minOccurs="0">
 *         &lt;xs:unique name="externalDataProfileUniqueness">
 *           &lt;xs:selector xpath="./p3:Profile"/>
 *           &lt;xs:field xpath="@UniqueID"/>
 *           &lt;xs:field xpath="@ClientCode"/>
 *           &lt;xs:field xpath="@DomainID"/>
 *         &lt;/xs:unique>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="xs:string" use="optional" default="Y" name="TPFSynchronization"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileToPNRRQ implements Serializable
{
    private int choiceSelect = -1;
    private static final int FILTER_PATH_CHOICE = 0;
    private static final int PROFILE_PATH_CHOICE = 1;
    private static final int TEMPORARY_FILTER_PATH_CHOICE = 2;
    private FilterPathType filterPath;
    private ProfilePathType profilePath;
    private TemporaryFilterPathType temporaryFilterPath;
    private ExternalDataType externalData;
    private Date timeStamp;
    private Target target;
    private String version;
    private String TPFSynchronization;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FilterPath is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFilterPath() {
        return choiceSelect == FILTER_PATH_CHOICE;
    }

    /** 
     * Get the 'FilterPath' element value. Path if Filter is used
     * 
     * @return value
     */
    public FilterPathType getFilterPath() {
        return filterPath;
    }

    /** 
     * Set the 'FilterPath' element value. Path if Filter is used
     * 
     * @param filterPath
     */
    public void setFilterPath(FilterPathType filterPath) {
        setChoiceSelect(FILTER_PATH_CHOICE);
        this.filterPath = filterPath;
    }

    /** 
     * Check if ProfilePath is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfilePath() {
        return choiceSelect == PROFILE_PATH_CHOICE;
    }

    /** 
     * Get the 'ProfilePath' element value. Path if Profile is used for move instead of filter
     * 
     * @return value
     */
    public ProfilePathType getProfilePath() {
        return profilePath;
    }

    /** 
     * Set the 'ProfilePath' element value. Path if Profile is used for move instead of filter
     * 
     * @param profilePath
     */
    public void setProfilePath(ProfilePathType profilePath) {
        setChoiceSelect(PROFILE_PATH_CHOICE);
        this.profilePath = profilePath;
    }

    /** 
     * Check if TemporaryFilterPath is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemporaryFilterPath() {
        return choiceSelect == TEMPORARY_FILTER_PATH_CHOICE;
    }

    /** 
     * Get the 'TemporaryFilterPath' element value. Path if full text of filter is used
     * 
     * @return value
     */
    public TemporaryFilterPathType getTemporaryFilterPath() {
        return temporaryFilterPath;
    }

    /** 
     * Set the 'TemporaryFilterPath' element value. Path if full text of filter is used
     * 
     * @param temporaryFilterPath
     */
    public void setTemporaryFilterPath(
            TemporaryFilterPathType temporaryFilterPath) {
        setChoiceSelect(TEMPORARY_FILTER_PATH_CHOICE);
        this.temporaryFilterPath = temporaryFilterPath;
    }

    /** 
     * Get the 'ExternalData' element value.
     * 
     * @return value
     */
    public ExternalDataType getExternalData() {
        return externalData;
    }

    /** 
     * Set the 'ExternalData' element value.
     * 
     * @param externalData
     */
    public void setExternalData(ExternalDataType externalData) {
        this.externalData = externalData;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'TPFSynchronization' attribute value.
     * 
     * @return value
     */
    public String getTPFSynchronization() {
        return TPFSynchronization;
    }

    /** 
     * Set the 'TPFSynchronization' attribute value.
     * 
     * @param TPFSynchronization
     */
    public void setTPFSynchronization(String TPFSynchronization) {
        this.TPFSynchronization = TPFSynchronization;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
