
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Sabre Travel Policy Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreTravelPolicyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STPPolicyType" name="Policy" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element type="ns:STPPreferenceType" name="Preference" minOccurs="0" maxOccurs="50"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EntityID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SabreTravelPolicyType implements Serializable
{
    private List<STPPolicyType> policyList = new ArrayList<STPPolicyType>();
    private List<STPPreferenceType> preferenceList = new ArrayList<STPPreferenceType>();
    private String entityID;

    /** 
     * Get the list of 'Policy' element items. *** SABRE ADDED *** Policy ID information for SabreTravelPolicy element
     * 
     * @return list
     */
    public List<STPPolicyType> getPolicyList() {
        return policyList;
    }

    /** 
     * Set the list of 'Policy' element items. *** SABRE ADDED *** Policy ID information for SabreTravelPolicy element
     * 
     * @param list
     */
    public void setPolicyList(List<STPPolicyType> list) {
        policyList = list;
    }

    /** 
     * Get the list of 'Preference' element items. *** SABRE ADDED *** Preference ID information for SabreTravelPolicy element
     * 
     * @return list
     */
    public List<STPPreferenceType> getPreferenceList() {
        return preferenceList;
    }

    /** 
     * Set the list of 'Preference' element items. *** SABRE ADDED *** Preference ID information for SabreTravelPolicy element
     * 
     * @param list
     */
    public void setPreferenceList(List<STPPreferenceType> list) {
        preferenceList = list;
    }

    /** 
     * Get the 'EntityID' attribute value. *** SABRE ADDED ***  A unique identifier within Travel Policy for a group of travelers sharing a common travel policy and vendor preferences.
     * 
     * @return value
     */
    public String getEntityID() {
        return entityID;
    }

    /** 
     * Set the 'EntityID' attribute value. *** SABRE ADDED ***  A unique identifier within Travel Policy for a group of travelers sharing a common travel policy and vendor preferences.
     * 
     * @param entityID
     */
    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }
}
