
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 *  Search on AddressLine, CityName, StateCode, CountryCode and PostalCd
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchAddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCd" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchAddressType implements Serializable
{
    private List<String> addressLineList = new ArrayList<String>();
    private String cityName;
    private String stateCode;
    private String countryCode;
    private String postalCd;

    /** 
     * Get the list of 'AddressLine' element items. Search Functionality use 1st AddressLine to search all the address lines in the Profiles. 2nd, 3rd and 4th Address Lines in the search schema will be supported later.
     * 
     * @return list
     */
    public List<String> getAddressLineList() {
        return addressLineList;
    }

    /** 
     * Set the list of 'AddressLine' element items. Search Functionality use 1st AddressLine to search all the address lines in the Profiles. 2nd, 3rd and 4th Address Lines in the search schema will be supported later.
     * 
     * @param list
     */
    public void setAddressLineList(List<String> list) {
        addressLineList = list;
    }

    /** 
     * Get the 'CityName' element value.
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value.
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'StateCode' element value.
     * 
     * @return value
     */
    public String getStateCode() {
        return stateCode;
    }

    /** 
     * Set the 'StateCode' element value.
     * 
     * @param stateCode
     */
    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    /** 
     * Get the 'CountryCode' element value.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'PostalCd' element value.
     * 
     * @return value
     */
    public String getPostalCd() {
        return postalCd;
    }

    /** 
     * Set the 'PostalCd' element value.
     * 
     * @param postalCd
     */
    public void setPostalCd(String postalCd) {
        this.postalCd = postalCd;
    }
}
