
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchCustLoyaltyType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MembershipID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MembershipLevelValue"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchCustLoyaltyType implements Serializable
{
    private String vendorTypeCode;
    private String vendorCode;
    private String membershipID;
    private String membershipLevelValue;

    /** 
     * Get the 'VendorTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @return value
     */
    public String getMembershipID() {
        return membershipID;
    }

    /** 
     * Set the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @param membershipID
     */
    public void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    /** 
     * Get the 'MembershipLevelValue' attribute value.
     * 
     * @return value
     */
    public String getMembershipLevelValue() {
        return membershipLevelValue;
    }

    /** 
     * Set the 'MembershipLevelValue' attribute value.
     * 
     * @param membershipLevelValue
     */
    public void setMembershipLevelValue(String membershipLevelValue) {
        this.membershipLevelValue = membershipLevelValue;
    }
}
