
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Root element for profile content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileSearchRSTPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:AssociationHeaderType" name="Association" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="CreateDateTime"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchProfileType implements Serializable
{
    private ProfileSearchRSTPAIdentityType TPAIdentity;
    private Choice choice;
    private AssociationHeaderType association;
    private Date createDateTime;

    /** 
     * Get the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @return value
     */
    public ProfileSearchRSTPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(ProfileSearchRSTPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'Association' element value. ***SABRE ADDED*** To hold Association Identity information
     * 
     * @return value
     */
    public AssociationHeaderType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value. ***SABRE ADDED*** To hold Association Identity information
     * 
     * @param association
     */
    public void setAssociation(AssociationHeaderType association) {
        this.association = association;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:SearchRSTravelerProfileType" name="Traveler" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSTravelAgencyProfileType" name="TravelAgency" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSTravelAgentProfileType" name="TravelAgent" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSCorporateProfileType" name="Corporation" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSOperationalProfileType" name="OperationalProfile" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSGroupProfileType" name="GroupProfile" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int TRAVELER_CHOICE = 0;
        private static final int TRAVEL_AGENCY_CHOICE = 1;
        private static final int TRAVEL_AGENT_CHOICE = 2;
        private static final int CORPORATION_CHOICE = 3;
        private static final int OPERATIONAL_PROFILE_CHOICE = 4;
        private static final int GROUP_PROFILE_CHOICE = 5;
        private SearchRSTravelerProfileType traveler;
        private SearchRSTravelAgencyProfileType travelAgency;
        private SearchRSTravelAgentProfileType travelAgent;
        private SearchRSCorporateProfileType corporation;
        private SearchRSOperationalProfileType operationalProfile;
        private SearchRSGroupProfileType groupProfile;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Traveler is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTraveler() {
            return choiceSelect == TRAVELER_CHOICE;
        }

        /** 
         * Get the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
         * 
         * @return value
         */
        public SearchRSTravelerProfileType getTraveler() {
            return traveler;
        }

        /** 
         * Set the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
         * 
         * @param traveler
         */
        public void setTraveler(SearchRSTravelerProfileType traveler) {
            setChoiceSelect(TRAVELER_CHOICE);
            this.traveler = traveler;
        }

        /** 
         * Check if TravelAgency is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgency() {
            return choiceSelect == TRAVEL_AGENCY_CHOICE;
        }

        /** 
         * Get the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
         * 
         * @return value
         */
        public SearchRSTravelAgencyProfileType getTravelAgency() {
            return travelAgency;
        }

        /** 
         * Set the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
         * 
         * @param travelAgency
         */
        public void setTravelAgency(SearchRSTravelAgencyProfileType travelAgency) {
            setChoiceSelect(TRAVEL_AGENCY_CHOICE);
            this.travelAgency = travelAgency;
        }

        /** 
         * Check if TravelAgent is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgent() {
            return choiceSelect == TRAVEL_AGENT_CHOICE;
        }

        /** 
         * Get the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
         * 
         * @return value
         */
        public SearchRSTravelAgentProfileType getTravelAgent() {
            return travelAgent;
        }

        /** 
         * Set the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
         * 
         * @param travelAgent
         */
        public void setTravelAgent(SearchRSTravelAgentProfileType travelAgent) {
            setChoiceSelect(TRAVEL_AGENT_CHOICE);
            this.travelAgent = travelAgent;
        }

        /** 
         * Check if Corporation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCorporation() {
            return choiceSelect == CORPORATION_CHOICE;
        }

        /** 
         * Get the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @return value
         */
        public SearchRSCorporateProfileType getCorporation() {
            return corporation;
        }

        /** 
         * Set the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @param corporation
         */
        public void setCorporation(SearchRSCorporateProfileType corporation) {
            setChoiceSelect(CORPORATION_CHOICE);
            this.corporation = corporation;
        }

        /** 
         * Check if OperationalProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOperationalProfile() {
            return choiceSelect == OPERATIONAL_PROFILE_CHOICE;
        }

        /** 
         * Get the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operation  Profile 
         * 
         * @return value
         */
        public SearchRSOperationalProfileType getOperationalProfile() {
            return operationalProfile;
        }

        /** 
         * Set the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operation  Profile 
         * 
         * @param operationalProfile
         */
        public void setOperationalProfile(
                SearchRSOperationalProfileType operationalProfile) {
            setChoiceSelect(OPERATIONAL_PROFILE_CHOICE);
            this.operationalProfile = operationalProfile;
        }

        /** 
         * Check if GroupProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGroupProfile() {
            return choiceSelect == GROUP_PROFILE_CHOICE;
        }

        /** 
         * Get the 'GroupProfile' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @return value
         */
        public SearchRSGroupProfileType getGroupProfile() {
            return groupProfile;
        }

        /** 
         * Set the 'GroupProfile' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @param groupProfile
         */
        public void setGroupProfile(SearchRSGroupProfileType groupProfile) {
            setChoiceSelect(GROUP_PROFILE_CHOICE);
            this.groupProfile = groupProfile;
        }
    }
}
