
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Agent BackOffice information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSBusinessSystemIdentityInfoType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="SystemName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="IdentifierType"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSBusinessSystemIdentityInfoType implements Serializable
{
    private String systemName;
    private String ID;
    private String description;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String informationText;
    private String identifierType;

    /** 
     * Get the 'SystemName' attribute value.  other System identity system  name 
     * 
     * @return value
     */
    public String getSystemName() {
        return systemName;
    }

    /** 
     * Set the 'SystemName' attribute value.  other System identity system  name 
     * 
     * @param systemName
     */
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    /** 
     * Get the 'ID' attribute value. Other System Identity ID 
     * 
     * @return value
     */
    public String getID() {
        return ID;
    }

    /** 
     * Set the 'ID' attribute value. Other System Identity ID 
     * 
     * @param ID
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /** 
     * Get the 'Description' attribute value. *** Deprecated *** Description
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' attribute value. *** Deprecated *** Description
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a BusinessSystemIdentityInfo
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a BusinessSystemIdentityInfo
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'IdentifierType' attribute value. Identifier type. Can be used if there are multiple identifieres defined.
     * 
     * @return value
     */
    public String getIdentifierType() {
        return identifierType;
    }

    /** 
     * Set the 'IdentifierType' attribute value. Identifier type. Can be used if there are multiple identifieres defined.
     * 
     * @param identifierType
     */
    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }
}
