
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * *** SABRE ADDED *** Response for Filter Search request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSFilterInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Message" minOccurs="0"/>
 *     &lt;xs:element type="ns:FilterListElementType" name="FilterList" minOccurs="0" maxOccurs="250"/>
 *     &lt;xs:element type="ns:FilterType" name="Filter" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSFilterInfoType implements Serializable
{
    private String message;
    private List<FilterListElementType> filterList = new ArrayList<FilterListElementType>();
    private FilterType filter;

    /** 
     * Get the 'Message' element value. *** SABRE ADDED *** Search Specific Response Messages
     * 
     * @return value
     */
    public String getMessage() {
        return message;
    }

    /** 
     * Set the 'Message' element value. *** SABRE ADDED *** Search Specific Response Messages
     * 
     * @param message
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /** 
     * Get the list of 'FilterList' element items. *** SABRE ADDED *** List of Filter Ids upto 250
     * 
     * @return list
     */
    public List<FilterListElementType> getFilterList() {
        return filterList;
    }

    /** 
     * Set the list of 'FilterList' element items. *** SABRE ADDED *** List of Filter Ids upto 250
     * 
     * @param list
     */
    public void setFilterList(List<FilterListElementType> list) {
        filterList = list;
    }

    /** 
     * Get the 'Filter' element value. *** SABRE ADDED *** Return Filter only if there is an exact match 
     * 
     * @return value
     */
    public FilterType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value. *** SABRE ADDED *** Return Filter only if there is an exact match 
     * 
     * @param filter
     */
    public void setFilter(FilterType filter) {
        this.filter = filter;
    }
}
