
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Data for group profiles 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSGroupProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SearchRSGroupProfileInfoType" name="GroupInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSAddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSTelephoneType" name="Telephone" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSEmailType" name="Email" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSAssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:SearchRSRemarkType" name="Remark" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSCustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSBusinessSystemIdentityInfoType" name="BusinessSystemIdentity" minOccurs="0"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSSabreTravelPolicy" name="TravelPolicy" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSGroupProfileType implements Serializable
{
    private SearchRSGroupProfileInfoType groupInfo;
    private SearchRSAddressType address;
    private SearchRSTelephoneType telephone;
    private SearchRSEmailType email;
    private List<SearchRSAssociatedProfilesType> associatedProfileList = new ArrayList<SearchRSAssociatedProfilesType>();
    private SearchRSRemarkType remark;
    private SearchRSCustomerReferenceInfoType customerReferenceInfo;
    private SearchRSBusinessSystemIdentityInfoType businessSystemIdentity;
    private AssociatedTemplateType associatedTemplate;
    private SearchRSSabreTravelPolicy travelPolicy;

    /** 
     * Get the 'GroupInfo' element value. ***SABRE ADDED*** Group information
     * 
     * @return value
     */
    public SearchRSGroupProfileInfoType getGroupInfo() {
        return groupInfo;
    }

    /** 
     * Set the 'GroupInfo' element value. ***SABRE ADDED*** Group information
     * 
     * @param groupInfo
     */
    public void setGroupInfo(SearchRSGroupProfileInfoType groupInfo) {
        this.groupInfo = groupInfo;
    }

    /** 
     * Get the 'Address' element value. *** SABRE ADDED *** Corporation Address data 
     * 
     * @return value
     */
    public SearchRSAddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. *** SABRE ADDED *** Corporation Address data 
     * 
     * @param address
     */
    public void setAddress(SearchRSAddressType address) {
        this.address = address;
    }

    /** 
     * Get the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @return value
     */
    public SearchRSTelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @param telephone
     */
    public void setTelephone(SearchRSTelephoneType telephone) {
        this.telephone = telephone;
    }

    /** 
     * Get the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @return value
     */
    public SearchRSEmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @param email
     */
    public void setEmail(SearchRSEmailType email) {
        this.email = email;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Associated profiles
     * 
     * @return list
     */
    public List<SearchRSAssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Associated profiles
     * 
     * @param list
     */
    public void setAssociatedProfileList(
            List<SearchRSAssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return value
     */
    public SearchRSRemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param remark
     */
    public void setRemark(SearchRSRemarkType remark) {
        this.remark = remark;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public SearchRSCustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            SearchRSCustomerReferenceInfoType customerReferenceInfo) {
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Get the 'BusinessSystemIdentity' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public SearchRSBusinessSystemIdentityInfoType getBusinessSystemIdentity() {
        return businessSystemIdentity;
    }

    /** 
     * Set the 'BusinessSystemIdentity' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param businessSystemIdentity
     */
    public void setBusinessSystemIdentity(
            SearchRSBusinessSystemIdentityInfoType businessSystemIdentity) {
        this.businessSystemIdentity = businessSystemIdentity;
    }

    /** 
     * Get the 'AssociatedTemplate' element value.
     * 
     * @return value
     */
    public AssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value.
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(AssociatedTemplateType associatedTemplate) {
        this.associatedTemplate = associatedTemplate;
    }

    /** 
     * Get the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @return value
     */
    public SearchRSSabreTravelPolicy getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(SearchRSSabreTravelPolicy travelPolicy) {
        this.travelPolicy = travelPolicy;
    }
}
