
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Travel Agency Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSOperationalProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ContactNameOperationalType" name="ContactName" minOccurs="0"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSRemarkType" name="Remark" minOccurs="0"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSBusinessSystemIdentityInfoType" name="BusinessSystemIdentity" minOccurs="0"/>
 *     &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSOperationalProfileType implements Serializable
{
    private ContactNameOperationalType contactName;
    private TelephoneType telephone;
    private EmailType email;
    private AddressType address;
    private SearchRSRemarkType remark;
    private CustomerReferenceInfoType customerReferenceInfo;
    private SearchRSBusinessSystemIdentityInfoType businessSystemIdentity;
    private List<AssociatedProfilesType> associatedProfileList = new ArrayList<AssociatedProfilesType>();
    private AssociatedTemplateType associatedTemplate;

    /** 
     * Get the 'ContactName' element value. ***OTA Based *** Person Name Information 
     * 
     * @return value
     */
    public ContactNameOperationalType getContactName() {
        return contactName;
    }

    /** 
     * Set the 'ContactName' element value. ***OTA Based *** Person Name Information 
     * 
     * @param contactName
     */
    public void setContactName(ContactNameOperationalType contactName) {
        this.contactName = contactName;
    }

    /** 
     * Get the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @return value
     */
    public TelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @param telephone
     */
    public void setTelephone(TelephoneType telephone) {
        this.telephone = telephone;
    }

    /** 
     * Get the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @return value
     */
    public EmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @param email
     */
    public void setEmail(EmailType email) {
        this.email = email;
    }

    /** 
     * Get the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @return value
     */
    public AddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @param address
     */
    public void setAddress(AddressType address) {
        this.address = address;
    }

    /** 
     * Get the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return value
     */
    public SearchRSRemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param remark
     */
    public void setRemark(SearchRSRemarkType remark) {
        this.remark = remark;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public CustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            CustomerReferenceInfoType customerReferenceInfo) {
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Get the 'BusinessSystemIdentity' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public SearchRSBusinessSystemIdentityInfoType getBusinessSystemIdentity() {
        return businessSystemIdentity;
    }

    /** 
     * Set the 'BusinessSystemIdentity' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param businessSystemIdentity
     */
    public void setBusinessSystemIdentity(
            SearchRSBusinessSystemIdentityInfoType businessSystemIdentity) {
        this.businessSystemIdentity = businessSystemIdentity;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Associated profiles
     * 
     * @return list
     */
    public List<AssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Associated profiles
     * 
     * @param list
     */
    public void setAssociatedProfileList(List<AssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the 'AssociatedTemplate' element value.
     * 
     * @return value
     */
    public AssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value.
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(AssociatedTemplateType associatedTemplate) {
        this.associatedTemplate = associatedTemplate;
    }
}
