
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSTelephoneType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="FullPhoneNumber"/>
 *     &lt;xs:element type="ns:ParsedPhoneNumberType" name="ParsedPhoneNumber"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LocationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PurposeCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSTelephoneType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FULL_PHONE_NUMBER_CHOICE = 0;
    private static final int PARSED_PHONE_NUMBER_CHOICE = 1;
    private String fullPhoneNumber;
    private ParsedPhoneNumberType parsedPhoneNumber;
    private String locationTypeCode;
    private String languageIDCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String purposeCode;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FullPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFullPhoneNumber() {
        return choiceSelect == FULL_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'FullPhoneNumber' element value.
     * 
     * @return value
     */
    public String getFullPhoneNumber() {
        return fullPhoneNumber;
    }

    /** 
     * Set the 'FullPhoneNumber' element value.
     * 
     * @param fullPhoneNumber
     */
    public void setFullPhoneNumber(String fullPhoneNumber) {
        setChoiceSelect(FULL_PHONE_NUMBER_CHOICE);
        this.fullPhoneNumber = fullPhoneNumber;
    }

    /** 
     * Check if ParsedPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifParsedPhoneNumber() {
        return choiceSelect == PARSED_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'ParsedPhoneNumber' element value.
     * 
     * @return value
     */
    public ParsedPhoneNumberType getParsedPhoneNumber() {
        return parsedPhoneNumber;
    }

    /** 
     * Set the 'ParsedPhoneNumber' element value.
     * 
     * @param parsedPhoneNumber
     */
    public void setParsedPhoneNumber(ParsedPhoneNumberType parsedPhoneNumber) {
        setChoiceSelect(PARSED_PHONE_NUMBER_CHOICE);
        this.parsedPhoneNumber = parsedPhoneNumber;
    }

    /** 
     * Get the 'LocationTypeCode' attribute value. Refer to OTA Code List Phone Location Type (PLT).
    	
     * 
     * @return value
     */
    public String getLocationTypeCode() {
        return locationTypeCode;
    }

    /** 
     * Set the 'LocationTypeCode' attribute value. Refer to OTA Code List Phone Location Type (PLT).
    	
     * 
     * @param locationTypeCode
     */
    public void setLocationTypeCode(String locationTypeCode) {
        this.locationTypeCode = locationTypeCode;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @return value
     */
    public String getPurposeCode() {
        return purposeCode;
    }

    /** 
     * Set the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @param purposeCode
     */
    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }
}
