
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchValidatorType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="ValidatorID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ValidatorName"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchValidatorType implements Serializable
{
    private String validatorID;
    private String domainID;
    private String profileTypeCode;
    private String clientCode;
    private String clientContextCode;
    private String validatorName;

    /** 
     * Get the 'ValidatorID' attribute value. *** SABRE ADDED *** ID of Validator in the database
     * 
     * @return value
     */
    public String getValidatorID() {
        return validatorID;
    }

    /** 
     * Set the 'ValidatorID' attribute value. *** SABRE ADDED *** ID of Validator in the database
     * 
     * @param validatorID
     */
    public void setValidatorID(String validatorID) {
        this.validatorID = validatorID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public String getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(String profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'ValidatorName' attribute value. Name of the validator
     * 
     * @return value
     */
    public String getValidatorName() {
        return validatorName;
    }

    /** 
     * Set the 'ValidatorName' attribute value. Name of the validator
     * 
     * @param validatorName
     */
    public void setValidatorName(String validatorName) {
        this.validatorName = validatorName;
    }
}
