
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Identifes the subject areas availalbe in PPP
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubjectAreaNamesType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Association"/>
 *     &lt;xs:enumeration value="PersonName"/>
 *     &lt;xs:enumeration value="Telephone"/>
 *     &lt;xs:enumeration value="Email"/>
 *     &lt;xs:enumeration value="Address"/>
 *     &lt;xs:enumeration value="Document"/>
 *     &lt;xs:enumeration value="CustLoyalty"/>
 *     &lt;xs:enumeration value="EmergencyContactPerson"/>
 *     &lt;xs:enumeration value="EmploymentInfo"/>
 *     &lt;xs:enumeration value="PaymentForm"/>
 *     &lt;xs:enumeration value="RelatedIndividual"/>
 *     &lt;xs:enumeration value="AirlinePref"/>
 *     &lt;xs:enumeration value="HotelPref"/>
 *     &lt;xs:enumeration value="VehicleRentalPref"/>
 *     &lt;xs:enumeration value="RailPref"/>
 *     &lt;xs:enumeration value="GroundTransportationPref"/>
 *     &lt;xs:enumeration value="NotificationPref"/>
 *     &lt;xs:enumeration value="Consent"/>
 *     &lt;xs:enumeration value="PsychographicCategory"/>
 *     &lt;xs:enumeration value="PriorityRemarks"/>
 *     &lt;xs:enumeration value="Remark"/>
 *     &lt;xs:enumeration value="SSR"/>
 *     &lt;xs:enumeration value="OSI"/>
 *     &lt;xs:enumeration value="CustomerReferenceInfo"/>
 *     &lt;xs:enumeration value="BusinessSystemIdentityInfo"/>
 *     &lt;xs:enumeration value="AssociatedProfiles"/>
 *     &lt;xs:enumeration value="AssociatedFilters"/>
 *     &lt;xs:enumeration value="AssociatedTemplates"/>
 *     &lt;xs:enumeration value="AssociatedFormats"/>
 *     &lt;xs:enumeration value="Discounts"/>
 *     &lt;xs:enumeration value="CustomDefinedData"/>
 *     &lt;xs:enumeration value="CustomDefinedValues"/>
 *     &lt;xs:enumeration value="TaxInfo"/>
 *     &lt;xs:enumeration value="CustomProfileRoles"/>
 *     &lt;xs:enumeration value="StandardProfileRoles"/>
 *     &lt;xs:enumeration value="SabreTravelPolicyEngine"/>
 *     &lt;xs:enumeration value="SabreCorporateTravelPolicy"/>
 *     &lt;xs:enumeration value="TransactionalData"/>
 *     &lt;xs:enumeration value="STARData"/>
 *     &lt;xs:enumeration value="CustomerValueScore"/>
 *     &lt;xs:enumeration value="EnrollmentInfo"/>
 *     &lt;xs:enumeration value="MergedProfiles"/>
 *     &lt;xs:enumeration value="AgencyContactName"/>
 *     &lt;xs:enumeration value="AgencyInfo"/>
 *     &lt;xs:enumeration value="GDS"/>
 *     &lt;xs:enumeration value="Branding"/>
 *     &lt;xs:enumeration value="QueueAssignments"/>
 *     &lt;xs:enumeration value="Commissions"/>
 *     &lt;xs:enumeration value="AgentName"/>
 *     &lt;xs:enumeration value="AgentInfo"/>
 *     &lt;xs:enumeration value="AgentRelatedIndividuals"/>
 *     &lt;xs:enumeration value="AgentGDSIdentity"/>
 *     &lt;xs:enumeration value="SabreSecurityEntityAttribute"/>
 *     &lt;xs:enumeration value="Incentives"/>
 *     &lt;xs:enumeration value="BusinessTravelerSetting"/>
 *     &lt;xs:enumeration value="ContactName"/>
 *     &lt;xs:enumeration value="CorporateInfo"/>
 *     &lt;xs:enumeration value="GroupInfo"/>
 *     &lt;xs:enumeration value="Login"/>
 *     &lt;xs:enumeration value="Login/@PasswordHash"/>
 *     &lt;xs:enumeration value="NumberOfAssocProfiles"/>
 *     &lt;xs:enumeration value="SabreTravelPolicy"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SubjectAreaNamesType implements Serializable {
    ASSOCIATION("Association"), PERSON_NAME("PersonName"), TELEPHONE(
            "Telephone"), EMAIL("Email"), ADDRESS("Address"), DOCUMENT(
            "Document"), CUST_LOYALTY("CustLoyalty"), EMERGENCY_CONTACT_PERSON(
            "EmergencyContactPerson"), EMPLOYMENT_INFO("EmploymentInfo"), PAYMENT_FORM(
            "PaymentForm"), RELATED_INDIVIDUAL("RelatedIndividual"), AIRLINE_PREF(
            "AirlinePref"), HOTEL_PREF("HotelPref"), VEHICLE_RENTAL_PREF(
            "VehicleRentalPref"), RAIL_PREF("RailPref"), GROUND_TRANSPORTATION_PREF(
            "GroundTransportationPref"), NOTIFICATION_PREF("NotificationPref"), CONSENT(
            "Consent"), PSYCHOGRAPHIC_CATEGORY("PsychographicCategory"), PRIORITY_REMARKS(
            "PriorityRemarks"), REMARK("Remark"), SSR("SSR"), OSI("OSI"), CUSTOMER_REFERENCE_INFO(
            "CustomerReferenceInfo"), BUSINESS_SYSTEM_IDENTITY_INFO(
            "BusinessSystemIdentityInfo"), ASSOCIATED_PROFILES(
            "AssociatedProfiles"), ASSOCIATED_FILTERS("AssociatedFilters"), ASSOCIATED_TEMPLATES(
            "AssociatedTemplates"), ASSOCIATED_FORMATS("AssociatedFormats"), DISCOUNTS(
            "Discounts"), CUSTOM_DEFINED_DATA("CustomDefinedData"), CUSTOM_DEFINED_VALUES(
            "CustomDefinedValues"), TAX_INFO("TaxInfo"), CUSTOM_PROFILE_ROLES(
            "CustomProfileRoles"), STANDARD_PROFILE_ROLES(
            "StandardProfileRoles"), SABRE_TRAVEL_POLICY_ENGINE(
            "SabreTravelPolicyEngine"), SABRE_CORPORATE_TRAVEL_POLICY(
            "SabreCorporateTravelPolicy"), TRANSACTIONAL_DATA(
            "TransactionalData"), STAR_DATA("STARData"), CUSTOMER_VALUE_SCORE(
            "CustomerValueScore"), ENROLLMENT_INFO("EnrollmentInfo"), MERGED_PROFILES(
            "MergedProfiles"), AGENCY_CONTACT_NAME("AgencyContactName"), AGENCY_INFO(
            "AgencyInfo"), GDS("GDS"), BRANDING("Branding"), QUEUE_ASSIGNMENTS(
            "QueueAssignments"), COMMISSIONS("Commissions"), AGENT_NAME(
            "AgentName"), AGENT_INFO("AgentInfo"), AGENT_RELATED_INDIVIDUALS(
            "AgentRelatedIndividuals"), AGENT_GDS_IDENTITY("AgentGDSIdentity"), SABRE_SECURITY_ENTITY_ATTRIBUTE(
            "SabreSecurityEntityAttribute"), INCENTIVES("Incentives"), BUSINESS_TRAVELER_SETTING(
            "BusinessTravelerSetting"), CONTACT_NAME("ContactName"), CORPORATE_INFO(
            "CorporateInfo"), GROUP_INFO("GroupInfo"), LOGIN("Login"), LOGIN_PASSWORD_HASH(
            "Login/@PasswordHash"), NUMBER_OF_ASSOC_PROFILES(
            "NumberOfAssocProfiles"), SABRE_TRAVEL_POLICY("SabreTravelPolicy");
    private final String value;

    private SubjectAreaNamesType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SubjectAreaNamesType convert(String value) {
        for (SubjectAreaNamesType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
