
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A placeholder in the schema to allow for additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:SSRType" name="SSR" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:OSIType" name="OSI" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AssociatedFiltersType" name="AssociatedFilters" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate" minOccurs="0" maxOccurs="25"/>
 *     &lt;xs:element type="ns:AssociatedFormatsType" name="AssociatedFormats" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TravelPolicyType" name="TravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:STARDataType" name="STARData" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:CustomerValueScoreType" name="CustomerValueScore" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:EnrollmentInfoType" name="EnrollmentInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:MergedProfilesType" name="MergedProfiles" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:NumberOfAssocProfilesType" name="NumberOfAssocProfiles" minOccurs="0"/>
 *     &lt;xs:element type="ns:CustomDefinedValuesType" name="CustomDefinedValues" minOccurs="0" maxOccurs="500"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TPAExtensionsType implements Serializable
{
    private List<PriorityRemarksType> priorityRemarkList = new ArrayList<PriorityRemarksType>();
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private List<SSRType> SSRList = new ArrayList<SSRType>();
    private List<OSIType> OSIList = new ArrayList<OSIType>();
    private List<CustomerReferenceInfoType> customerReferenceInfoList = new ArrayList<CustomerReferenceInfoType>();
    private List<BusinessSystemIdentityInfoType> businessSystemIdentityInfoList = new ArrayList<BusinessSystemIdentityInfoType>();
    private List<AssociatedProfilesType> associatedProfileList = new ArrayList<AssociatedProfilesType>();
    private List<AssociatedFiltersType> associatedFilterList = new ArrayList<AssociatedFiltersType>();
    private List<AssociatedTemplateType> associatedTemplateList = new ArrayList<AssociatedTemplateType>();
    private List<AssociatedFormatsType> associatedFormatList = new ArrayList<AssociatedFormatsType>();
    private List<DiscountsType> discountList = new ArrayList<DiscountsType>();
    private List<CustomDefinedDataType> customDefinedDataList = new ArrayList<CustomDefinedDataType>();
    private List<TaxInfoType> taxInfoList = new ArrayList<TaxInfoType>();
    private TravelPolicyType travelPolicy;
    private List<STARDataType> STARDataList = new ArrayList<STARDataType>();
    private List<CustomerValueScoreType> customerValueScoreList = new ArrayList<CustomerValueScoreType>();
    private EnrollmentInfoType enrollmentInfo;
    private List<MergedProfilesType> mergedProfileList = new ArrayList<MergedProfilesType>();
    private NumberOfAssocProfilesType numberOfAssocProfiles;
    private List<CustomDefinedValuesType> customDefinedValueList = new ArrayList<CustomDefinedValuesType>();

    /** 
     * Get the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @return list
     */
    public List<PriorityRemarksType> getPriorityRemarkList() {
        return priorityRemarkList;
    }

    /** 
     * Set the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @param list
     */
    public void setPriorityRemarkList(List<PriorityRemarksType> list) {
        priorityRemarkList = list;
    }

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @return list
     */
    public List<SSRType> getSSRList() {
        return SSRList;
    }

    /** 
     * Set the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @param list
     */
    public void setSSRList(List<SSRType> list) {
        SSRList = list;
    }

    /** 
     * Get the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @return list
     */
    public List<OSIType> getOSIList() {
        return OSIList;
    }

    /** 
     * Set the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @param list
     */
    public void setOSIList(List<OSIType> list) {
        OSIList = list;
    }

    /** 
     * Get the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return list
     */
    public List<CustomerReferenceInfoType> getCustomerReferenceInfoList() {
        return customerReferenceInfoList;
    }

    /** 
     * Set the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param list
     */
    public void setCustomerReferenceInfoList(
            List<CustomerReferenceInfoType> list) {
        customerReferenceInfoList = list;
    }

    /** 
     * Get the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @return list
     */
    public List<BusinessSystemIdentityInfoType> getBusinessSystemIdentityInfoList() {
        return businessSystemIdentityInfoList;
    }

    /** 
     * Set the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @param list
     */
    public void setBusinessSystemIdentityInfoList(
            List<BusinessSystemIdentityInfoType> list) {
        businessSystemIdentityInfoList = list;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @return list
     */
    public List<AssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @param list
     */
    public void setAssociatedProfileList(List<AssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the list of 'AssociatedFilters' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Filters Associated to a  profile
     * 
     * @return list
     */
    public List<AssociatedFiltersType> getAssociatedFilterList() {
        return associatedFilterList;
    }

    /** 
     * Set the list of 'AssociatedFilters' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Filters Associated to a  profile
     * 
     * @param list
     */
    public void setAssociatedFilterList(List<AssociatedFiltersType> list) {
        associatedFilterList = list;
    }

    /** 
     * Get the list of 'AssociatedTemplate' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Template Associated to a  profile
     * 
     * @return list
     */
    public List<AssociatedTemplateType> getAssociatedTemplateList() {
        return associatedTemplateList;
    }

    /** 
     * Set the list of 'AssociatedTemplate' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Template Associated to a  profile
     * 
     * @param list
     */
    public void setAssociatedTemplateList(List<AssociatedTemplateType> list) {
        associatedTemplateList = list;
    }

    /** 
     * Get the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return list
     */
    public List<AssociatedFormatsType> getAssociatedFormatList() {
        return associatedFormatList;
    }

    /** 
     * Set the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param list
     */
    public void setAssociatedFormatList(List<AssociatedFormatsType> list) {
        associatedFormatList = list;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<DiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<DiscountsType> list) {
        discountList = list;
    }

    /** 
     * Get the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return list
     */
    public List<CustomDefinedDataType> getCustomDefinedDataList() {
        return customDefinedDataList;
    }

    /** 
     * Set the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param list
     */
    public void setCustomDefinedDataList(List<CustomDefinedDataType> list) {
        customDefinedDataList = list;
    }

    /** 
     * Get the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return list
     */
    public List<TaxInfoType> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param list
     */
    public void setTaxInfoList(List<TaxInfoType> list) {
        taxInfoList = list;
    }

    /** 
     * Get the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @return value
     */
    public TravelPolicyType getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(TravelPolicyType travelPolicy) {
        this.travelPolicy = travelPolicy;
    }

    /** 
     * Get the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @return list
     */
    public List<STARDataType> getSTARDataList() {
        return STARDataList;
    }

    /** 
     * Set the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @param list
     */
    public void setSTARDataList(List<STARDataType> list) {
        STARDataList = list;
    }

    /** 
     * Get the list of 'CustomerValueScore' element items. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @return list
     */
    public List<CustomerValueScoreType> getCustomerValueScoreList() {
        return customerValueScoreList;
    }

    /** 
     * Set the list of 'CustomerValueScore' element items. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @param list
     */
    public void setCustomerValueScoreList(List<CustomerValueScoreType> list) {
        customerValueScoreList = list;
    }

    /** 
     * Get the 'EnrollmentInfo' element value. *** SABRE ADDED *** Information about Enrollments
     * 
     * @return value
     */
    public EnrollmentInfoType getEnrollmentInfo() {
        return enrollmentInfo;
    }

    /** 
     * Set the 'EnrollmentInfo' element value. *** SABRE ADDED *** Information about Enrollments
     * 
     * @param enrollmentInfo
     */
    public void setEnrollmentInfo(EnrollmentInfoType enrollmentInfo) {
        this.enrollmentInfo = enrollmentInfo;
    }

    /** 
     * Get the list of 'MergedProfiles' element items. *** SABRE ADDED *** Information about Profiles that are merged into this profile
     * 
     * @return list
     */
    public List<MergedProfilesType> getMergedProfileList() {
        return mergedProfileList;
    }

    /** 
     * Set the list of 'MergedProfiles' element items. *** SABRE ADDED *** Information about Profiles that are merged into this profile
     * 
     * @param list
     */
    public void setMergedProfileList(List<MergedProfilesType> list) {
        mergedProfileList = list;
    }

    /** 
     * Get the 'NumberOfAssocProfiles' element value. *** SABRE ADDED *** Number of profiles associated to and from this profile
     * 
     * @return value
     */
    public NumberOfAssocProfilesType getNumberOfAssocProfiles() {
        return numberOfAssocProfiles;
    }

    /** 
     * Set the 'NumberOfAssocProfiles' element value. *** SABRE ADDED *** Number of profiles associated to and from this profile
     * 
     * @param numberOfAssocProfiles
     */
    public void setNumberOfAssocProfiles(
            NumberOfAssocProfilesType numberOfAssocProfiles) {
        this.numberOfAssocProfiles = numberOfAssocProfiles;
    }

    /** 
     * Get the list of 'CustomDefinedValues' element items. *** SABRE ADDED *** Customer Defined Values can store any name/value pairs that can represent any customer data. There are no restrictions on the content of Name or Value. Name element can be stored without Value.
     * 
     * @return list
     */
    public List<CustomDefinedValuesType> getCustomDefinedValueList() {
        return customDefinedValueList;
    }

    /** 
     * Set the list of 'CustomDefinedValues' element items. *** SABRE ADDED *** Customer Defined Values can store any name/value pairs that can represent any customer data. There are no restrictions on the content of Name or Value. Name element can be stored without Value.
     * 
     * @param list
     */
    public void setCustomDefinedValueList(List<CustomDefinedValuesType> list) {
        customDefinedValueList = list;
    }
}
