
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Root element for Filter content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateAssociatedFiltersType">
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="FilterID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FilterName"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateAssociatedFiltersType implements Serializable
{
    private String domainID;
    private String filterID;
    private String sequenceNo;
    private String displaySequenceNo;
    private String filterName;

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'FilterID' attribute value.
     * 
     * @return value
     */
    public String getFilterID() {
        return filterID;
    }

    /** 
     * Set the 'FilterID' attribute value.
     * 
     * @param filterID
     */
    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    /** 
     * Get the 'SequenceNo' attribute value.
     * 
     * @return value
     */
    public String getSequenceNo() {
        return sequenceNo;
    }

    /** 
     * Set the 'SequenceNo' attribute value.
     * 
     * @param sequenceNo
     */
    public void setSequenceNo(String sequenceNo) {
        this.sequenceNo = sequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'FilterName' attribute value. *** SABRE ADDED *** Name of the filter 
     * 
     * @return value
     */
    public String getFilterName() {
        return filterName;
    }

    /** 
     * Set the 'FilterName' attribute value. *** SABRE ADDED *** Name of the filter 
     * 
     * @param filterName
     */
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }
}
