
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Travel Agency Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateOperationalProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ContactNameOperationalType" name="ContactName" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:SSRType" name="SSR" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:OSIType" name="OSI" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:PrefCollectionsType" name="PrefCollections" minOccurs="0"/>
 *     &lt;xs:element type="ns:TravelPolicyType" name="TravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:STARDataType" name="STARData" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:SabreCorporateTravelPolicyType" name="SabreCorporateTravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo" minOccurs="0" maxOccurs="50"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateOperationalProfileType implements Serializable
{
    private List<ContactNameOperationalType> contactNameList = new ArrayList<ContactNameOperationalType>();
    private List<TelephoneType> telephoneList = new ArrayList<TelephoneType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private List<PaymentFormType> paymentFormList = new ArrayList<PaymentFormType>();
    private List<PriorityRemarksType> priorityRemarkList = new ArrayList<PriorityRemarksType>();
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private List<CustomerReferenceInfoType> customerReferenceInfoList = new ArrayList<CustomerReferenceInfoType>();
    private List<SSRType> SSRList = new ArrayList<SSRType>();
    private List<OSIType> OSIList = new ArrayList<OSIType>();
    private List<DiscountsType> discountList = new ArrayList<DiscountsType>();
    private List<CustomDefinedDataType> customDefinedDataList = new ArrayList<CustomDefinedDataType>();
    private PrefCollectionsType prefCollections;
    private TravelPolicyType travelPolicy;
    private List<STARDataType> STARDataList = new ArrayList<STARDataType>();
    private SabreCorporateTravelPolicyType sabreCorporateTravelPolicy;
    private List<EmploymentInfoType> employmentInfoList = new ArrayList<EmploymentInfoType>();

    /** 
     * Get the list of 'ContactName' element items. ***OTA Based *** Person Name Information 
     * 
     * @return list
     */
    public List<ContactNameOperationalType> getContactNameList() {
        return contactNameList;
    }

    /** 
     * Set the list of 'ContactName' element items. ***OTA Based *** Person Name Information 
     * 
     * @param list
     */
    public void setContactNameList(List<ContactNameOperationalType> list) {
        contactNameList = list;
    }

    /** 
     * Get the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @return list
     */
    public List<TelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @param list
     */
    public void setTelephoneList(List<TelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @return list
     */
    public List<PaymentFormType> getPaymentFormList() {
        return paymentFormList;
    }

    /** 
     * Set the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @param list
     */
    public void setPaymentFormList(List<PaymentFormType> list) {
        paymentFormList = list;
    }

    /** 
     * Get the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @return list
     */
    public List<PriorityRemarksType> getPriorityRemarkList() {
        return priorityRemarkList;
    }

    /** 
     * Set the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @param list
     */
    public void setPriorityRemarkList(List<PriorityRemarksType> list) {
        priorityRemarkList = list;
    }

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return list
     */
    public List<CustomerReferenceInfoType> getCustomerReferenceInfoList() {
        return customerReferenceInfoList;
    }

    /** 
     * Set the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param list
     */
    public void setCustomerReferenceInfoList(
            List<CustomerReferenceInfoType> list) {
        customerReferenceInfoList = list;
    }

    /** 
     * Get the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @return list
     */
    public List<SSRType> getSSRList() {
        return SSRList;
    }

    /** 
     * Set the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @param list
     */
    public void setSSRList(List<SSRType> list) {
        SSRList = list;
    }

    /** 
     * Get the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @return list
     */
    public List<OSIType> getOSIList() {
        return OSIList;
    }

    /** 
     * Set the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @param list
     */
    public void setOSIList(List<OSIType> list) {
        OSIList = list;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<DiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<DiscountsType> list) {
        discountList = list;
    }

    /** 
     * Get the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return list
     */
    public List<CustomDefinedDataType> getCustomDefinedDataList() {
        return customDefinedDataList;
    }

    /** 
     * Set the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param list
     */
    public void setCustomDefinedDataList(List<CustomDefinedDataType> list) {
        customDefinedDataList = list;
    }

    /** 
     * Get the 'PrefCollections' element value. ***OTA Based*** Preferences of a Profile 
     * 
     * @return value
     */
    public PrefCollectionsType getPrefCollections() {
        return prefCollections;
    }

    /** 
     * Set the 'PrefCollections' element value. ***OTA Based*** Preferences of a Profile 
     * 
     * @param prefCollections
     */
    public void setPrefCollections(PrefCollectionsType prefCollections) {
        this.prefCollections = prefCollections;
    }

    /** 
     * Get the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @return value
     */
    public TravelPolicyType getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(TravelPolicyType travelPolicy) {
        this.travelPolicy = travelPolicy;
    }

    /** 
     * Get the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @return list
     */
    public List<STARDataType> getSTARDataList() {
        return STARDataList;
    }

    /** 
     * Set the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @param list
     */
    public void setSTARDataList(List<STARDataType> list) {
        STARDataList = list;
    }

    /** 
     * Get the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @return value
     */
    public SabreCorporateTravelPolicyType getSabreCorporateTravelPolicy() {
        return sabreCorporateTravelPolicy;
    }

    /** 
     * Set the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @param sabreCorporateTravelPolicy
     */
    public void setSabreCorporateTravelPolicy(
            SabreCorporateTravelPolicyType sabreCorporateTravelPolicy) {
        this.sabreCorporateTravelPolicy = sabreCorporateTravelPolicy;
    }

    /** 
     * Get the list of 'EmploymentInfo' element items. *** SABRE ADDED *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @return list
     */
    public List<EmploymentInfoType> getEmploymentInfoList() {
        return employmentInfoList;
    }

    /** 
     * Set the list of 'EmploymentInfo' element items. *** SABRE ADDED *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @param list
     */
    public void setEmploymentInfoList(List<EmploymentInfoType> list) {
        employmentInfoList = list;
    }
}
