
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Added by Sabre
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateTPAIdentityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:LoginType" name="Login" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="UniqueID"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileName"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="Y" name="ProfileNameModifyIndicator"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileDescription"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="ns:StatusType" use="optional" default="AC" name="ProfileStatusCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfilePurgeNoDays"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateTPAIdentityType implements Serializable
{
    private LoginType login;
    private String clientCode;
    private String clientContextCode;
    private String uniqueID;
    private ProfileTypeInfo profileTypeCode;
    private String profileName;
    private YesNoType profileNameModifyIndicator;
    private String profileDescription;
    private String domainID;
    private StatusType profileStatusCode;
    private String profilePurgeNoDays;

    /** 
     * Get the 'Login' element value.
     * 
     * @return value
     */
    public LoginType getLogin() {
        return login;
    }

    /** 
     * Set the 'Login' element value.
     * 
     * @param login
     */
    public void setLogin(LoginType login) {
        this.login = login;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'UniqueID' attribute value.
     * 
     * @return value
     */
    public String getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' attribute value.
     * 
     * @param uniqueID
     */
    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ProfileName' attribute value.
     * 
     * @return value
     */
    public String getProfileName() {
        return profileName;
    }

    /** 
     * Set the 'ProfileName' attribute value.
     * 
     * @param profileName
     */
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    /** 
     * Get the 'ProfileNameModifyIndicator' attribute value. Indicates if profile name can be modified or not 
     * 
     * @return value
     */
    public YesNoType getProfileNameModifyIndicator() {
        return profileNameModifyIndicator;
    }

    /** 
     * Set the 'ProfileNameModifyIndicator' attribute value. Indicates if profile name can be modified or not 
     * 
     * @param profileNameModifyIndicator
     */
    public void setProfileNameModifyIndicator(
            YesNoType profileNameModifyIndicator) {
        this.profileNameModifyIndicator = profileNameModifyIndicator;
    }

    /** 
     * Get the 'ProfileDescription' attribute value. Description of a profile if needed 
     * 
     * @return value
     */
    public String getProfileDescription() {
        return profileDescription;
    }

    /** 
     * Set the 'ProfileDescription' attribute value. Description of a profile if needed 
     * 
     * @param profileDescription
     */
    public void setProfileDescription(String profileDescription) {
        this.profileDescription = profileDescription;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ProfileStatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getProfileStatusCode() {
        return profileStatusCode;
    }

    /** 
     * Set the 'ProfileStatusCode' attribute value.
     * 
     * @param profileStatusCode
     */
    public void setProfileStatusCode(StatusType profileStatusCode) {
        this.profileStatusCode = profileStatusCode;
    }

    /** 
     * Get the 'ProfilePurgeNoDays' attribute value. Number of days after which the profile should be purged
    	
     * 
     * @return value
     */
    public String getProfilePurgeNoDays() {
        return profilePurgeNoDays;
    }

    /** 
     * Set the 'ProfilePurgeNoDays' attribute value. Number of days after which the profile should be purged
    	
     * 
     * @param profilePurgeNoDays
     */
    public void setProfilePurgeNoDays(String profilePurgeNoDays) {
        this.profilePurgeNoDays = profilePurgeNoDays;
    }
}
