
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Root element for Filter content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemporaryFilterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FilterProfileType" name="Profile"/>
 *     &lt;xs:element type="ns:ProfileToPNRFormatStringType" name="FormatString" minOccurs="0" maxOccurs="100"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MainProfileOrderSeqNo"/>
 *   &lt;xs:attribute type="ns:FormatOrderingSequenceModeType" use="optional" name="FormatOrderingSequenceMode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemporaryFilterType implements Serializable
{
    private FilterProfileType profile;
    private List<ProfileToPNRFormatStringType> formatStringList = new ArrayList<ProfileToPNRFormatStringType>();
    private String mainProfileOrderSeqNo;
    private FormatOrderingSequenceModeType formatOrderingSequenceMode;

    /** 
     * Get the 'Profile' element value. *** OTA Based *** Filter Strucutre of a profile data 
     * 
     * @return value
     */
    public FilterProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. *** OTA Based *** Filter Strucutre of a profile data 
     * 
     * @param profile
     */
    public void setProfile(FilterProfileType profile) {
        this.profile = profile;
    }

    /** 
     * Get the list of 'FormatString' element items. *** SABRE ADDED *** Formats as Strings that needs to be moved direclty into PNR with out parsing 
     * 
     * @return list
     */
    public List<ProfileToPNRFormatStringType> getFormatStringList() {
        return formatStringList;
    }

    /** 
     * Set the list of 'FormatString' element items. *** SABRE ADDED *** Formats as Strings that needs to be moved direclty into PNR with out parsing 
     * 
     * @param list
     */
    public void setFormatStringList(List<ProfileToPNRFormatStringType> list) {
        formatStringList = list;
    }

    /** 
     * Get the 'MainProfileOrderSeqNo' attribute value. Indicates position of Main Profile among Associated Profiles
     * 
     * @return value
     */
    public String getMainProfileOrderSeqNo() {
        return mainProfileOrderSeqNo;
    }

    /** 
     * Set the 'MainProfileOrderSeqNo' attribute value. Indicates position of Main Profile among Associated Profiles
     * 
     * @param mainProfileOrderSeqNo
     */
    public void setMainProfileOrderSeqNo(String mainProfileOrderSeqNo) {
        this.mainProfileOrderSeqNo = mainProfileOrderSeqNo;
    }

    /** 
     * Get the 'FormatOrderingSequenceMode' attribute value. Ordering mode for Formats of Main Profile and Associated Profiles
     * 
     * @return value
     */
    public FormatOrderingSequenceModeType getFormatOrderingSequenceMode() {
        return formatOrderingSequenceMode;
    }

    /** 
     * Set the 'FormatOrderingSequenceMode' attribute value. Ordering mode for Formats of Main Profile and Associated Profiles
     * 
     * @param formatOrderingSequenceMode
     */
    public void setFormatOrderingSequenceMode(
            FormatOrderingSequenceModeType formatOrderingSequenceMode) {
        this.formatOrderingSequenceMode = formatOrderingSequenceMode;
    }
}
