
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Travel Policy Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPolicyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SabreTravelPolicyEngineType" name="SabreTravelPolicyEngine" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element type="ns:SabreCorporateTravelPolicyType" name="SabreCorporateTravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:SabreTravelPolicyType" name="SabreTravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelPolicyType implements Serializable
{
    private List<SabreTravelPolicyEngineType> sabreTravelPolicyEngineList = new ArrayList<SabreTravelPolicyEngineType>();
    private SabreCorporateTravelPolicyType sabreCorporateTravelPolicy;
    private SabreTravelPolicyType sabreTravelPolicy;
    private TransactionalDataType transactionalData;

    /** 
     * Get the list of 'SabreTravelPolicyEngine' element items. *** DEPRECATED *** This element will be removed during next major schema release
     * 
     * @return list
     */
    public List<SabreTravelPolicyEngineType> getSabreTravelPolicyEngineList() {
        return sabreTravelPolicyEngineList;
    }

    /** 
     * Set the list of 'SabreTravelPolicyEngine' element items. *** DEPRECATED *** This element will be removed during next major schema release
     * 
     * @param list
     */
    public void setSabreTravelPolicyEngineList(
            List<SabreTravelPolicyEngineType> list) {
        sabreTravelPolicyEngineList = list;
    }

    /** 
     * Get the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @return value
     */
    public SabreCorporateTravelPolicyType getSabreCorporateTravelPolicy() {
        return sabreCorporateTravelPolicy;
    }

    /** 
     * Set the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @param sabreCorporateTravelPolicy
     */
    public void setSabreCorporateTravelPolicy(
            SabreCorporateTravelPolicyType sabreCorporateTravelPolicy) {
        this.sabreCorporateTravelPolicy = sabreCorporateTravelPolicy;
    }

    /** 
     * Get the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @return value
     */
    public SabreTravelPolicyType getSabreTravelPolicy() {
        return sabreTravelPolicy;
    }

    /** 
     * Set the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @param sabreTravelPolicy
     */
    public void setSabreTravelPolicy(SabreTravelPolicyType sabreTravelPolicy) {
        this.sabreTravelPolicy = sabreTravelPolicy;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }
}
