
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Sabre Added Enumeration for VIT STAR line types
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VIT_StarLineType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value=""/>
 *     &lt;xs:enumeration value="S"/>
 *     &lt;xs:enumeration value="P"/>
 *     &lt;xs:enumeration value="A"/>
 *     &lt;xs:enumeration value="O"/>
 *     &lt;xs:enumeration value="N"/>
 *     &lt;xs:enumeration value="R"/>
 *     &lt;xs:enumeration value="F"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum VITStarLineType implements Serializable {
    _(""), S("S"), P("P"), A("A"), O("O"), N("N"), R("R"), F("F");
    private final String value;

    private VITStarLineType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static VITStarLineType convert(String value) {
        for (VITStarLineType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
