
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatorIDType">
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ValidatorID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ValidatorIDType implements Serializable
{
    private String domainID;
    private String validatorID;
    private String clientCode;

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ValidatorID' attribute value. *** SABRE ADDED *** ID of Validator in the database
     * 
     * @return value
     */
    public String getValidatorID() {
        return validatorID;
    }

    /** 
     * Set the 'ValidatorID' attribute value. *** SABRE ADDED *** ID of Validator in the database
     * 
     * @param validatorID
     */
    public void setValidatorID(String validatorID) {
        this.validatorID = validatorID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }
}
