
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatorSearchCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SearchValidatorType" name="Validator"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PageNumber"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="ReturnCount"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="CountAll"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ValidatorSearchCriteriaType implements Serializable
{
    private SearchValidatorType validator;
    private String pageNumber;
    private BigInteger returnCount;
    private YesNoType countAll;

    /** 
     * Get the 'Validator' element value.
     * 
     * @return value
     */
    public SearchValidatorType getValidator() {
        return validator;
    }

    /** 
     * Set the 'Validator' element value.
     * 
     * @param validator
     */
    public void setValidator(SearchValidatorType validator) {
        this.validator = validator;
    }

    /** 
     * Get the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @return value
     */
    public String getPageNumber() {
        return pageNumber;
    }

    /** 
     * Set the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @param pageNumber
     */
    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    /** 
     * Get the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @return value
     */
    public BigInteger getReturnCount() {
        return returnCount;
    }

    /** 
     * Set the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @param returnCount
     */
    public void setReturnCount(BigInteger returnCount) {
        this.returnCount = returnCount;
    }

    /** 
     * Get the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @return value
     */
    public YesNoType getCountAll() {
        return countAll;
    }

    /** 
     * Set the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @param countAll
     */
    public void setCountAll(YesNoType countAll) {
        this.countAll = countAll;
    }
}
