
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatorType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ValidatorIdentityType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:ValidatorRuleType" name="ValidatorRule" maxOccurs="1000"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="CreateDateTime"/>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="UpdateDateTime"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="ValidatorDescription"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ValidatorType extends ValidatorIdentityType implements
    Serializable
{
    private List<ValidatorRuleType> validatorRuleList = new ArrayList<ValidatorRuleType>();
    private Date createDateTime;
    private Date updateDateTime;
    private String validatorDescription;

    /** 
     * Get the list of 'ValidatorRule' element items.
     * 
     * @return list
     */
    public List<ValidatorRuleType> getValidatorRuleList() {
        return validatorRuleList;
    }

    /** 
     * Set the list of 'ValidatorRule' element items.
     * 
     * @param list
     */
    public void setValidatorRuleList(List<ValidatorRuleType> list) {
        validatorRuleList = list;
    }

    /** 
     * Get the 'CreateDateTime' attribute value.
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value.
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value.
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value.
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /** 
     * Get the 'ValidatorDescription' attribute value.
     * 
     * @return value
     */
    public String getValidatorDescription() {
        return validatorDescription;
    }

    /** 
     * Set the 'ValidatorDescription' attribute value.
     * 
     * @param validatorDescription
     */
    public void setValidatorDescription(String validatorDescription) {
        this.validatorDescription = validatorDescription;
    }
}
