
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Standard way to indicate successful processing of an OTA message, but one in which warnings are generated
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WarningsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:WarningMessageType" name="WarningMessage" maxOccurs="100"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class WarningsType implements Serializable
{
    private List<WarningMessageType> warningMessageList = new ArrayList<WarningMessageType>();

    /** 
     * Get the list of 'WarningMessage' element items.
     * 
     * @return list
     */
    public List<WarningMessageType> getWarningMessageList() {
        return warningMessageList;
    }

    /** 
     * Set the list of 'WarningMessage' element items.
     * 
     * @param list
     */
    public void setWarningMessageList(List<WarningMessageType> list) {
        warningMessageList = list;
    }
}
