
package com.sabre.ns.ticketing.pqs;

import com.sabre.ns.ticketing.ttl.HeaderBase;
import com.sabre.ns.ticketing.ttl.IdentifierPOS;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConvertPQPayloadRQ">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns1:Header.Base" name="Header" minOccurs="0"/>
 *     &lt;xs:element type="ns1:Identifier.POS" name="POS" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.SearchParameters" name="SearchParameters"/>
 *     &lt;xs:element type="ns:Payload" name="Payload" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PriceQuoteStdAttributes"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteStdAttributes">
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ConvertPQPayloadRQ implements Serializable
{
    private HeaderBase header;
    private IdentifierPOS POS;
    private PriceQuoteSearchParameters searchParameters;
    private Payload payload;
    private String version;

    /** 
     * Get the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @return value
     */
    public HeaderBase getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @param header
     */
    public void setHeader(HeaderBase header) {
        this.header = header;
    }

    /** 
     * Get the 'POS' element value. Point Of Sale and Agent information.
     * 
     * @return value
     */
    public IdentifierPOS getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point Of Sale and Agent information.
     * 
     * @param POS
     */
    public void setPOS(IdentifierPOS POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'SearchParameters' element value. Search parameters that allow selecting what information from Price Quote are requested.
     * 
     * @return value
     */
    public PriceQuoteSearchParameters getSearchParameters() {
        return searchParameters;
    }

    /** 
     * Set the 'SearchParameters' element value. Search parameters that allow selecting what information from Price Quote are requested.
     * 
     * @param searchParameters
     */
    public void setSearchParameters(PriceQuoteSearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    /** 
     * Get the 'Payload' element value. Binary PQ/PQR Payleoad
     * 
     * @return value
     */
    public Payload getPayload() {
        return payload;
    }

    /** 
     * Set the 'Payload' element value. Binary PQ/PQR Payleoad
     * 
     * @param payload
     */
    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    /** 
     * Get the 'version' attribute value. Version of the service the service consumer wishes to use.
    				NOTE: In order for SWSO to be able to capture the version of the service being used in their logs/statistics,
    				this attribute needs to be named Version (with a capital letter - which is against our naming convention).
    			
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Version of the service the service consumer wishes to use.
    				NOTE: In order for SWSO to be able to capture the version of the service being used in their logs/statistics,
    				this attribute needs to be named Version (with a capital letter - which is against our naming convention).
    			
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
