
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyConversion">
 *   &lt;xs:attribute type="xs:string" use="required" name="fromCurrency"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="toCurrency"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="rateOfExchange"/>
 *   &lt;xs:attribute name="rateOfExchangeType">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class RateOfExchangeType -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:boolean" name="rateOfExchangeOverride"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrencyConversion implements Serializable
{
    private String fromCurrency;
    private String toCurrency;
    private String rateOfExchange;
    private RateOfExchangeType rateOfExchangeType;
    private Boolean rateOfExchangeOverride;

    /** 
     * Get the 'fromCurrency' attribute value. Ref: DM0Z_85_BCUR
    				Base currency
     * 
     * @return value
     */
    public String getFromCurrency() {
        return fromCurrency;
    }

    /** 
     * Set the 'fromCurrency' attribute value. Ref: DM0Z_85_BCUR
    				Base currency
     * 
     * @param fromCurrency
     */
    public void setFromCurrency(String fromCurrency) {
        this.fromCurrency = fromCurrency;
    }

    /** 
     * Get the 'toCurrency' attribute value. Ref: DM0Z_85_ECUR
    				Equivalent currency
     * 
     * @return value
     */
    public String getToCurrency() {
        return toCurrency;
    }

    /** 
     * Set the 'toCurrency' attribute value. Ref: DM0Z_85_ECUR
    				Equivalent currency
     * 
     * @param toCurrency
     */
    public void setToCurrency(String toCurrency) {
        this.toCurrency = toCurrency;
    }

    /** 
     * Get the 'rateOfExchange' attribute value. Ref: DM0Z_85_CCVN
    				Rate Of Exchange
     * 
     * @return value
     */
    public String getRateOfExchange() {
        return rateOfExchange;
    }

    /** 
     * Set the 'rateOfExchange' attribute value. Ref: DM0Z_85_CCVN
    				Rate Of Exchange
     * 
     * @param rateOfExchange
     */
    public void setRateOfExchange(String rateOfExchange) {
        this.rateOfExchange = rateOfExchange;
    }

    /** 
     * Get the 'rateOfExchangeType' attribute value. Ref: DM0Z_85_CNVI
    				Possible values:
    				- Fixed
    				- BSR
    				- BBR
    				- ICH
     * 
     * @return value
     */
    public RateOfExchangeType getRateOfExchangeType() {
        return rateOfExchangeType;
    }

    /** 
     * Set the 'rateOfExchangeType' attribute value. Ref: DM0Z_85_CNVI
    				Possible values:
    				- Fixed
    				- BSR
    				- BBR
    				- ICH
     * 
     * @param rateOfExchangeType
     */
    public void setRateOfExchangeType(RateOfExchangeType rateOfExchangeType) {
        this.rateOfExchangeType = rateOfExchangeType;
    }

    /** 
     * Get the 'rateOfExchangeOverride' attribute value. Ref: #DM0Z_85_COV
    				ROE override
     * 
     * @return value
     */
    public Boolean getRateOfExchangeOverride() {
        return rateOfExchangeOverride;
    }

    /** 
     * Set the 'rateOfExchangeOverride' attribute value. Ref: #DM0Z_85_COV
    				ROE override
     * 
     * @param rateOfExchangeOverride
     */
    public void setRateOfExchangeOverride(Boolean rateOfExchangeOverride) {
        this.rateOfExchangeOverride = rateOfExchangeOverride;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Fixed"/>
     *     &lt;xs:enumeration value="ICH"/>
     *     &lt;xs:enumeration value="BBR"/>
     *     &lt;xs:enumeration value="BSR"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum RateOfExchangeType implements Serializable {
        FIXED("Fixed"), ICH("ICH"), BBR("BBR"), BSR("BSR");
        private final String value;

        private RateOfExchangeType(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static RateOfExchangeType convert(String value) {
            for (RateOfExchangeType inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
