
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.Indicators">
 *   &lt;xs:attribute type="xs:boolean" name="governmentApproval"/>
 *   &lt;xs:attribute type="xs:boolean" name="negotiatedFare"/>
 *   &lt;xs:attribute type="xs:string" name="privateFareType"/>
 *   &lt;xs:attribute type="xs:boolean" name="NUC_Suppression"/>
 *   &lt;xs:attribute type="xs:boolean" name="netValues"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareIndicators implements Serializable
{
    private Boolean governmentApproval;
    private Boolean negotiatedFare;
    private String privateFareType;
    private Boolean NUCSuppression;
    private Boolean netValues;

    /** 
     * Get the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

    				Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
    			
     * 
     * @return value
     */
    public Boolean getGovernmentApproval() {
        return governmentApproval;
    }

    /** 
     * Set the 'governmentApproval' attribute value. Set to true if the fare has been subject to the government approval

    				Ref: DM0Z_85_FIN1, #DM0Z_85_CAB
    			
     * 
     * @param governmentApproval
     */
    public void setGovernmentApproval(Boolean governmentApproval) {
        this.governmentApproval = governmentApproval;
    }

    /** 
     * Get the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

    				Ref:
    				Abacus
    				DM0Z_40_FSCI
    				#DM0Z_40_XFAR
    				DM0Z_E8_RMT_TYPE

    				Infini
    				DM0Z_40_RSTA #DM0Z_40_MAN
    				DM0Z_85_BC35
    				#DM0Z_85_BCAT
     * 
     * @return value
     */
    public Boolean getNegotiatedFare() {
        return negotiatedFare;
    }

    /** 
     * Set the 'negotiatedFare' attribute value. Set to true when PQ fare is a negotiated fare

    				Ref:
    				Abacus
    				DM0Z_40_FSCI
    				#DM0Z_40_XFAR
    				DM0Z_E8_RMT_TYPE

    				Infini
    				DM0Z_40_RSTA #DM0Z_40_MAN
    				DM0Z_85_BC35
    				#DM0Z_85_BCAT
     * 
     * @param negotiatedFare
     */
    public void setNegotiatedFare(Boolean negotiatedFare) {
        this.negotiatedFare = negotiatedFare;
    }

    /** 
     * Get the 'privateFareType' attribute value. private fare indicator

    				Ref: DM0Z_85_PVT_FAR
     * 
     * @return value
     */
    public String getPrivateFareType() {
        return privateFareType;
    }

    /** 
     * Set the 'privateFareType' attribute value. private fare indicator

    				Ref: DM0Z_85_PVT_FAR
     * 
     * @param privateFareType
     */
    public void setPrivateFareType(String privateFareType) {
        this.privateFareType = privateFareType;
    }

    /** 
     * Get the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

    				Ref: DM0Z_65_ID01
    				#DM0Z_65_NUC 
     * 
     * @return value
     */
    public Boolean getNUCSuppression() {
        return NUCSuppression;
    }

    /** 
     * Set the 'NUC_Suppression' attribute value. Set to true if the Neutral Unit Currency (NUC)/local currency amount in the fare calculation line on the ticket will be suppresed

    				Ref: DM0Z_65_ID01
    				#DM0Z_65_NUC 
     * 
     * @param NUCSuppression
     */
    public void setNUCSuppression(Boolean NUCSuppression) {
        this.NUCSuppression = NUCSuppression;
    }

    /** 
     * Get the 'netValues' attribute value. Identies both old and new fares are at Net Amounts
    				REF: #DM0Z_85_NETF
     * 
     * @return value
     */
    public Boolean getNetValues() {
        return netValues;
    }

    /** 
     * Set the 'netValues' attribute value. Identies both old and new fares are at Net Amounts
    				REF: #DM0Z_85_NETF
     * 
     * @param netValues
     */
    public void setNetValues(Boolean netValues) {
        this.netValues = netValues;
    }
}
