
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.OtherCommission">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CommissionAmount" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.CommissionVerification.Details" name="CommissionVerification" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="source"/>
 *   &lt;xs:attribute type="xs:string" name="provider"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareOtherCommission implements Serializable
{
    private CommissionAmount amount;
    private FareCommissionVerificationDetails commissionVerification;
    private String source;
    private String provider;

    /** 
     * Get the 'Amount' element value. Commision amount based on type
     * 
     * @return value
     */
    public CommissionAmount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Commision amount based on type
     * 
     * @param amount
     */
    public void setAmount(CommissionAmount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CommissionVerification' element value.
     * 
     * @return value
     */
    public FareCommissionVerificationDetails getCommissionVerification() {
        return commissionVerification;
    }

    /** 
     * Set the 'CommissionVerification' element value.
     * 
     * @param commissionVerification
     */
    public void setCommissionVerification(
            FareCommissionVerificationDetails commissionVerification) {
        this.commissionVerification = commissionVerification;
    }

    /** 
     * Get the 'source' attribute value. C35 - Category 35 Net commission
    				AMC - Agency Managed commission

    				Ref:
    				DM0Z_C9_TYPE
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'source' attribute value. C35 - Category 35 Net commission
    				AMC - Agency Managed commission

    				Ref:
    				DM0Z_C9_TYPE
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /** 
     * Get the 'provider' attribute value.
     * 
     * @return value
     */
    public String getProvider() {
        return provider;
    }

    /** 
     * Set the 'provider' attribute value.
     * 
     * @param provider
     */
    public void setProvider(String provider) {
        this.provider = provider;
    }
}
