
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.Tax">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Amount"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="code"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="paid"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="exempt"/>
 *   &lt;xs:attribute type="xs:boolean" name="refundable"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareTax implements Serializable
{
    private Amount amount;
    private String code;
    private Boolean paid;
    private Boolean exempt;
    private Boolean refundable;

    /** 
     * Get the 'Amount' element value. 	
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. 	
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'code' attribute value. Tax box identifier

    				Ref: DM0Z_CA_TID1
    				DM0Z_CA_TID2
    				DM0Z_CA_TID3

    				DM0Z_85_TID1
    				DM0Z_85_TID2
    				DM0Z_85_TID3
    			
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Tax box identifier

    				Ref: DM0Z_CA_TID1
    				DM0Z_CA_TID2
    				DM0Z_CA_TID3

    				DM0Z_85_TID1
    				DM0Z_85_TID2
    				DM0Z_85_TID3
    			
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'paid' attribute value. Ref:
    				DM0Z_CA_TXN1
    				#DM0Z_CA_PDT

    				DM0Z_85_TXN1
    				#DM0Z_85_PDT
    			
     * 
     * @return value
     */
    public Boolean getPaid() {
        return paid;
    }

    /** 
     * Set the 'paid' attribute value. Ref:
    				DM0Z_CA_TXN1
    				#DM0Z_CA_PDT

    				DM0Z_85_TXN1
    				#DM0Z_85_PDT
    			
     * 
     * @param paid
     */
    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    /** 
     * Get the 'exempt' attribute value. Ref:
    				DM0Z_CA_TXN1
    				#DM0Z_CA_ADC

    				DM0Z_85_TXN1
    				#DM0Z_85_ADC
    			
     * 
     * @return value
     */
    public Boolean getExempt() {
        return exempt;
    }

    /** 
     * Set the 'exempt' attribute value. Ref:
    				DM0Z_CA_TXN1
    				#DM0Z_CA_ADC

    				DM0Z_85_TXN1
    				#DM0Z_85_ADC
    			
     * 
     * @param exempt
     */
    public void setExempt(Boolean exempt) {
        this.exempt = exempt;
    }

    /** 
     * Get the 'refundable' attribute value. Ref: #DM0Z_90_NRF
     * 
     * @return value
     */
    public Boolean getRefundable() {
        return refundable;
    }

    /** 
     * Set the 'refundable' attribute value. Ref: #DM0Z_90_NRF
     * 
     * @param refundable
     */
    public void setRefundable(Boolean refundable) {
        this.refundable = refundable;
    }
}
