
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.TaxInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Fare.Tax" name="CombinedTax" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="ns:Fare.Tax" name="Tax" minOccurs="0" maxOccurs="198"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareTaxInfo implements Serializable
{
    private List<FareTax> combinedTaxList = new ArrayList<FareTax>();
    private List<FareTax> taxList = new ArrayList<FareTax>();

    /** 
     * Get the list of 'CombinedTax' element items. Taxes combined and represented in tax boxes 1, 2, 3

    				
     * 
     * @return list
     */
    public List<FareTax> getCombinedTaxList() {
        return combinedTaxList;
    }

    /** 
     * Set the list of 'CombinedTax' element items. Taxes combined and represented in tax boxes 1, 2, 3

    				
     * 
     * @param list
     */
    public void setCombinedTaxList(List<FareTax> list) {
        combinedTaxList = list;
    }

    /** 
     * Get the list of 'Tax' element items. Includes tax breakdown
     * 
     * @return list
     */
    public List<FareTax> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items. Includes tax breakdown
     * 
     * @param list
     */
    public void setTaxList(List<FareTax> list) {
        taxList = list;
    }
}
