
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PQFBP.TextType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:integer" use="required" name="number"/>
 *       &lt;xs:attribute type="xs:string" use="required" name="nameNumber"/>
 *       &lt;xs:attribute type="xs:integer" use="required" name="segmentNumber"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PQFBPTextType implements Serializable
{
    private String string;
    private BigInteger number;
    private String nameNumber;
    private BigInteger segmentNumber;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'number' attribute value. Sequence number
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. Sequence number
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
     * 
     * @return value
     */
    public String getNameNumber() {
        return nameNumber;
    }

    /** 
     * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
     * 
     * @param nameNumber
     */
    public void setNameNumber(String nameNumber) {
        this.nameNumber = nameNumber;
    }

    /** 
     * Get the 'segmentNumber' attribute value. Segment sequence number in PNR
     * 
     * @return value
     */
    public BigInteger getSegmentNumber() {
        return segmentNumber;
    }

    /** 
     * Set the 'segmentNumber' attribute value. Segment sequence number in PNR
     * 
     * @param segmentNumber
     */
    public void setSegmentNumber(BigInteger segmentNumber) {
        this.segmentNumber = segmentNumber;
    }
}
