
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.CommonFare">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalFare" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteCommonFare implements Serializable
{
    private Amount baseFare;
    private Amount equivalentFare;
    private Amount totalTax;
    private Amount totalFare;

    /** 
     * Get the 'BaseFare' element value. Base fare - passenger type
    					Ref: DM0Z_85_BFAR(Group) Value: DM0Z_85_BAMT (totals per type)
     * 
     * @return value
     */
    public Amount getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base fare - passenger type
    					Ref: DM0Z_85_BFAR(Group) Value: DM0Z_85_BAMT (totals per type)
     * 
     * @param baseFare
     */
    public void setBaseFare(Amount baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent Fare - passenger type
    					Ref: DM0Z_85_EFAR(Group) Value: DM0Z_85_EAMT (totals per type)
     * 
     * @return value
     */
    public Amount getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent Fare - passenger type
    					Ref: DM0Z_85_EFAR(Group) Value: DM0Z_85_EAMT (totals per type)
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(Amount equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Tax Total - passenger type
    					Ref:DM0Z_85_TTAC(Group) Value: DM0Z_85_TTAX (totals per type)	
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Tax Total - passenger type
    					Ref:DM0Z_85_TTAC(Group) Value: DM0Z_85_TTAX (totals per type)	
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value. Total fare inclusive of taxes -  passenger type
    					Ref: DM0Z_85_TFAR	(Group) Value: DM0Z_85_TAMT (totals per type)    		
     * 
     * @return value
     */
    public Amount getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value. Total fare inclusive of taxes -  passenger type
    					Ref: DM0Z_85_TFAR	(Group) Value: DM0Z_85_TAMT (totals per type)    		
     * 
     * @param totalFare
     */
    public void setTotalFare(Amount totalFare) {
        this.totalFare = totalFare;
    }
}
