
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Details.AgentInfo" name="AgentInfo"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.TransactionInfo" name="TransactionInfo"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.OrderInfo" name="OrderInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.NameAssociationInfo" name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.SegmentInfo" name="SegmentInfo" minOccurs="0" maxOccurs="30"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareInfo" name="FareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.AdditionalFareInfo" name="AdditionalFareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Item.Fee.Details" name="FeeInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.MiscellaneousInfo" name="MiscellaneousInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.PaymentInfo" name="PaymentInfo" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComparisonSummary" name="FareComparisonSummary" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.RefundInfo" name="RefundInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.ExchangeDocInfo" name="ExchangeDocInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.AddCollectInfo" name="AddCollectInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.ResidualInfo" name="ResidualInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.MessageInfo" name="MessageInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.HistoryInfo" name="HistoryInfo" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:Code.PQType" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="number"/>
 *   &lt;xs:attribute type="xs:string" name="passengerType"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="status"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
 *   &lt;xs:attribute type="xs:string" name="pricingStatus"/>
 *   &lt;xs:attribute type="xs:boolean" name="displayOnly"/>
 *   &lt;xs:attribute type="xs:string" name="reissueTransactionType"/>
 *   &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
 *   &lt;xs:attribute type="xs:boolean" name="incompletePQR"/>
 *   &lt;xs:attribute type="xs:boolean" name="createdByOrder"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="ataFormat"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetails implements Serializable
{
    private PriceQuoteDetailsAgentInfo agentInfo;
    private PriceQuoteDetailsTransactionInfo transactionInfo;
    private PriceQuoteDetailsOrderInfo orderInfo;
    private List<PriceQuoteDetailsNameAssociationInfo> nameAssociationInfoList = new ArrayList<PriceQuoteDetailsNameAssociationInfo>();
    private List<PriceQuoteDetailsSegmentInfo> segmentInfoList = new ArrayList<PriceQuoteDetailsSegmentInfo>();
    private PriceQuoteDetailsFareInfo fareInfo;
    private PriceQuoteDetailsAdditionalFareInfo additionalFareInfo;
    private PriceQuoteItemFeeDetails feeInfo;
    private PriceQuoteDetailsMiscellaneousInfo miscellaneousInfo;
    private List<PriceQuoteDetailsPaymentInfo> paymentInfoList = new ArrayList<PriceQuoteDetailsPaymentInfo>();
    private PriceQuoteDetailsFareComparisonSummary fareComparisonSummary;
    private PriceQuoteDetailsRefundInfo refundInfo;
    private List<PriceQuoteDetailsExchangeDocInfo> exchangeDocInfoList = new ArrayList<PriceQuoteDetailsExchangeDocInfo>();
    private PriceQuoteAddCollectInfo addCollectInfo;
    private PriceQuoteDetailsResidualInfo residualInfo;
    private PriceQuoteDetailsMessageInfo messageInfo;
    private List<PriceQuoteDetailsHistoryInfo> historyInfoList = new ArrayList<PriceQuoteDetailsHistoryInfo>();
    private CodePQType type;
    private BigInteger number;
    private String passengerType;
    private String status;
    private String pricingType;
    private String pricingStatus;
    private Boolean displayOnly;
    private String reissueTransactionType;
    private Boolean lowCostCarrier;
    private Boolean incompletePQR;
    private Boolean createdByOrder;
    private String ataFormat;

    /** 
     * Get the 'AgentInfo' element value. Information about the agent who created the PQ
     * 
     * @return value
     */
    public PriceQuoteDetailsAgentInfo getAgentInfo() {
        return agentInfo;
    }

    /** 
     * Set the 'AgentInfo' element value. Information about the agent who created the PQ
     * 
     * @param agentInfo
     */
    public void setAgentInfo(PriceQuoteDetailsAgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    /** 
     * Get the 'TransactionInfo' element value. Data at PQ transaction
    					level
     * 
     * @return value
     */
    public PriceQuoteDetailsTransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value. Data at PQ transaction
    					level
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(
            PriceQuoteDetailsTransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the 'OrderInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteDetailsOrderInfo getOrderInfo() {
        return orderInfo;
    }

    /** 
     * Set the 'OrderInfo' element value.
     * 
     * @param orderInfo
     */
    public void setOrderInfo(PriceQuoteDetailsOrderInfo orderInfo) {
        this.orderInfo = orderInfo;
    }

    /** 
     * Get the list of 'NameAssociationInfo' element items. List of associated traveler names for this PQ
     * 
     * @return list
     */
    public List<PriceQuoteDetailsNameAssociationInfo> getNameAssociationInfoList() {
        return nameAssociationInfoList;
    }

    /** 
     * Set the list of 'NameAssociationInfo' element items. List of associated traveler names for this PQ
     * 
     * @param list
     */
    public void setNameAssociationInfoList(
            List<PriceQuoteDetailsNameAssociationInfo> list) {
        nameAssociationInfoList = list;
    }

    /** 
     * Get the list of 'SegmentInfo' element items. Data associated to the segments priced within the PQ
     * 
     * @return list
     */
    public List<PriceQuoteDetailsSegmentInfo> getSegmentInfoList() {
        return segmentInfoList;
    }

    /** 
     * Set the list of 'SegmentInfo' element items. Data associated to the segments priced within the PQ
     * 
     * @param list
     */
    public void setSegmentInfoList(List<PriceQuoteDetailsSegmentInfo> list) {
        segmentInfoList = list;
    }

    /** 
     * Get the 'FareInfo' element value. Fare details associated to the selling fare equivalent *PQ
     * 
     * @return value
     */
    public PriceQuoteDetailsFareInfo getFareInfo() {
        return fareInfo;
    }

    /** 
     * Set the 'FareInfo' element value. Fare details associated to the selling fare equivalent *PQ
     * 
     * @param fareInfo
     */
    public void setFareInfo(PriceQuoteDetailsFareInfo fareInfo) {
        this.fareInfo = fareInfo;
    }

    /** 
     * Get the 'AdditionalFareInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteDetailsAdditionalFareInfo getAdditionalFareInfo() {
        return additionalFareInfo;
    }

    /** 
     * Set the 'AdditionalFareInfo' element value.
     * 
     * @param additionalFareInfo
     */
    public void setAdditionalFareInfo(
            PriceQuoteDetailsAdditionalFareInfo additionalFareInfo) {
        this.additionalFareInfo = additionalFareInfo;
    }

    /** 
     * Get the 'FeeInfo' element value. Fee details defined in Price Quote
     * 
     * @return value
     */
    public PriceQuoteItemFeeDetails getFeeInfo() {
        return feeInfo;
    }

    /** 
     * Set the 'FeeInfo' element value. Fee details defined in Price Quote
     * 
     * @param feeInfo
     */
    public void setFeeInfo(PriceQuoteItemFeeDetails feeInfo) {
        this.feeInfo = feeInfo;
    }

    /** 
     * Get the 'MiscellaneousInfo' element value. Miscellaneous details pertaining to this PQ
     * 
     * @return value
     */
    public PriceQuoteDetailsMiscellaneousInfo getMiscellaneousInfo() {
        return miscellaneousInfo;
    }

    /** 
     * Set the 'MiscellaneousInfo' element value. Miscellaneous details pertaining to this PQ
     * 
     * @param miscellaneousInfo
     */
    public void setMiscellaneousInfo(
            PriceQuoteDetailsMiscellaneousInfo miscellaneousInfo) {
        this.miscellaneousInfo = miscellaneousInfo;
    }

    /** 
     * Get the list of 'PaymentInfo' element items. Payment collection information
     * 
     * @return list
     */
    public List<PriceQuoteDetailsPaymentInfo> getPaymentInfoList() {
        return paymentInfoList;
    }

    /** 
     * Set the list of 'PaymentInfo' element items. Payment collection information
     * 
     * @param list
     */
    public void setPaymentInfoList(List<PriceQuoteDetailsPaymentInfo> list) {
        paymentInfoList = list;
    }

    /** 
     * Get the 'FareComparisonSummary' element value. Comparison Summary
     * 
     * @return value
     */
    public PriceQuoteDetailsFareComparisonSummary getFareComparisonSummary() {
        return fareComparisonSummary;
    }

    /** 
     * Set the 'FareComparisonSummary' element value. Comparison Summary
     * 
     * @param fareComparisonSummary
     */
    public void setFareComparisonSummary(
            PriceQuoteDetailsFareComparisonSummary fareComparisonSummary) {
        this.fareComparisonSummary = fareComparisonSummary;
    }

    /** 
     * Get the 'RefundInfo' element value. Refund due information
     * 
     * @return value
     */
    public PriceQuoteDetailsRefundInfo getRefundInfo() {
        return refundInfo;
    }

    /** 
     * Set the 'RefundInfo' element value. Refund due information
     * 
     * @param refundInfo
     */
    public void setRefundInfo(PriceQuoteDetailsRefundInfo refundInfo) {
        this.refundInfo = refundInfo;
    }

    /** 
     * Get the list of 'ExchangeDocInfo' element items. Old or Exchange Doc
    					Information
     * 
     * @return list
     */
    public List<PriceQuoteDetailsExchangeDocInfo> getExchangeDocInfoList() {
        return exchangeDocInfoList;
    }

    /** 
     * Set the list of 'ExchangeDocInfo' element items. Old or Exchange Doc
    					Information
     * 
     * @param list
     */
    public void setExchangeDocInfoList(
            List<PriceQuoteDetailsExchangeDocInfo> list) {
        exchangeDocInfoList = list;
    }

    /** 
     * Get the 'AddCollectInfo' element value. Additional Collection
    					for this Transaction
     * 
     * @return value
     */
    public PriceQuoteAddCollectInfo getAddCollectInfo() {
        return addCollectInfo;
    }

    /** 
     * Set the 'AddCollectInfo' element value. Additional Collection
    					for this Transaction
     * 
     * @param addCollectInfo
     */
    public void setAddCollectInfo(PriceQuoteAddCollectInfo addCollectInfo) {
        this.addCollectInfo = addCollectInfo;
    }

    /** 
     * Get the 'ResidualInfo' element value. Residual information
    on exchange
     * 
     * @return value
     */
    public PriceQuoteDetailsResidualInfo getResidualInfo() {
        return residualInfo;
    }

    /** 
     * Set the 'ResidualInfo' element value. Residual information
    on exchange
     * 
     * @param residualInfo
     */
    public void setResidualInfo(PriceQuoteDetailsResidualInfo residualInfo) {
        this.residualInfo = residualInfo;
    }

    /** 
     * Get the 'MessageInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteDetailsMessageInfo getMessageInfo() {
        return messageInfo;
    }

    /** 
     * Set the 'MessageInfo' element value.
     * 
     * @param messageInfo
     */
    public void setMessageInfo(PriceQuoteDetailsMessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    /** 
     * Get the list of 'HistoryInfo' element items.
     * 
     * @return list
     */
    public List<PriceQuoteDetailsHistoryInfo> getHistoryInfoList() {
        return historyInfoList;
    }

    /** 
     * Set the list of 'HistoryInfo' element items.
     * 
     * @param list
     */
    public void setHistoryInfoList(List<PriceQuoteDetailsHistoryInfo> list) {
        historyInfoList = list;
    }

    /** 
     * Get the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQ - Price Quote Record
    				PQR - Price Quote Reissue
    			
     * 
     * @return value
     */
    public CodePQType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQ - Price Quote Record
    				PQR - Price Quote Reissue
    			
     * 
     * @param type
     */
    public void setType(CodePQType type) {
        this.type = type;
    }

    /** 
     * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
    				Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
     * 
     * @return value
     */
    public String getPassengerType() {
        return passengerType;
    }

    /** 
     * Set the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
    				Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
     * 
     * @param passengerType
     */
    public void setPassengerType(String passengerType) {
        this.passengerType = passengerType;
    }

    /** 
     * Get the 'status' attribute value. PQ status
    				Possible values are:
    				A - Active
    				H - History
    				below values applicable only for airlines and not agencies
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. PQ status
    				Possible values are:
    				A - Active
    				H - History
    				below values applicable only for airlines and not agencies
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'pricingType' attribute value. Airlines/agencies
    				S - System
    				A - Ammended
    				M - Manual
     * 
     * @return value
     */
    public String getPricingType() {
        return pricingType;
    }

    /** 
     * Set the 'pricingType' attribute value. Airlines/agencies
    				S - System
    				A - Ammended
    				M - Manual
     * 
     * @param pricingType
     */
    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    /** 
     * Get the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

    				Possible values:

    				Abacus GDS
    				AUTO PRICED
    				MANUAL
    				RATE DESK

    				INFINI GDS
    				C-Guaranteed
    				W - With warning/Not guaranteed
    				M - amendments/Not guaranteed
    				A- overrides/Not guaranteed

    			
     * 
     * @return value
     */
    public String getPricingStatus() {
        return pricingStatus;
    }

    /** 
     * Set the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

    				Possible values:

    				Abacus GDS
    				AUTO PRICED
    				MANUAL
    				RATE DESK

    				INFINI GDS
    				C-Guaranteed
    				W - With warning/Not guaranteed
    				M - amendments/Not guaranteed
    				A- overrides/Not guaranteed

    			
     * 
     * @param pricingStatus
     */
    public void setPricingStatus(String pricingStatus) {
        this.pricingStatus = pricingStatus;
    }

    /** 
     * Get the 'displayOnly' attribute value. Set to true on PQ display only

    				Ref: DM0Z_85_BC35,#DM0Z_85_DOP
     * 
     * @return value
     */
    public Boolean getDisplayOnly() {
        return displayOnly;
    }

    /** 
     * Set the 'displayOnly' attribute value. Set to true on PQ display only

    				Ref: DM0Z_85_BC35,#DM0Z_85_DOP
     * 
     * @param displayOnly
     */
    public void setDisplayOnly(Boolean displayOnly) {
        this.displayOnly = displayOnly;
    }

    /** 
     * Get the 'reissueTransactionType' attribute value. EXCH or RFND transaction
     * 
     * @return value
     */
    public String getReissueTransactionType() {
        return reissueTransactionType;
    }

    /** 
     * Set the 'reissueTransactionType' attribute value. EXCH or RFND transaction
     * 
     * @param reissueTransactionType
     */
    public void setReissueTransactionType(String reissueTransactionType) {
        this.reissueTransactionType = reissueTransactionType;
    }

    /** 
     * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
    				Ref: #DM0Z_40_HCPQ
    				Value is false if attribute not present. 
     * 
     * @return value
     */
    public Boolean getLowCostCarrier() {
        return lowCostCarrier;
    }

    /** 
     * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
    				Ref: #DM0Z_40_HCPQ
    				Value is false if attribute not present. 
     * 
     * @param lowCostCarrier
     */
    public void setLowCostCarrier(Boolean lowCostCarrier) {
        this.lowCostCarrier = lowCostCarrier;
    }

    /** 
     * Get the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

    				REF: #DM0Z_40_PQC 
     * 
     * @return value
     */
    public Boolean getIncompletePQR() {
        return incompletePQR;
    }

    /** 
     * Set the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

    				REF: #DM0Z_40_PQC 
     * 
     * @param incompletePQR
     */
    public void setIncompletePQR(Boolean incompletePQR) {
        this.incompletePQR = incompletePQR;
    }

    /** 
     * Get the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
     * 
     * @return value
     */
    public Boolean getCreatedByOrder() {
        return createdByOrder;
    }

    /** 
     * Set the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
     * 
     * @param createdByOrder
     */
    public void setCreatedByOrder(Boolean createdByOrder) {
        this.createdByOrder = createdByOrder;
    }

    /** 
     * Get the 'ataFormat' attribute value. ATA format for display or prints 
    Ref: #DM0Z_65_PAT
     * 
     * @return value
     */
    public String getAtaFormat() {
        return ataFormat;
    }

    /** 
     * Set the 'ataFormat' attribute value. ATA format for display or prints 
    Ref: #DM0Z_65_PAT
     * 
     * @param ataFormat
     */
    public void setAtaFormat(String ataFormat) {
        this.ataFormat = ataFormat;
    }
}
