
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.FareComparisonSummary">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareDifference" name="FareDifference" minOccurs="0"/>
 *     &lt;xs:element name="NonRefundableFare" minOccurs="0">
 *       &lt;!-- Reference to inner class NonRefundableFare -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsFareComparisonSummary implements Serializable
{
    private PriceQuoteDetailsFareDifference fareDifference;
    private NonRefundableFare nonRefundableFare;

    /** 
     * Get the 'FareDifference' element value. Fare difference between new fare and fares from exchange document(s).
     * 
     * @return value
     */
    public PriceQuoteDetailsFareDifference getFareDifference() {
        return fareDifference;
    }

    /** 
     * Set the 'FareDifference' element value. Fare difference between new fare and fares from exchange document(s).
     * 
     * @param fareDifference
     */
    public void setFareDifference(PriceQuoteDetailsFareDifference fareDifference) {
        this.fareDifference = fareDifference;
    }

    /** 
     * Get the 'NonRefundableFare' element value.
     * 
     * @return value
     */
    public NonRefundableFare getNonRefundableFare() {
        return nonRefundableFare;
    }

    /** 
     * Set the 'NonRefundableFare' element value.
     * 
     * @param nonRefundableFare
     */
    public void setNonRefundableFare(NonRefundableFare nonRefundableFare) {
        this.nonRefundableFare = nonRefundableFare;
    }
    /** 
     * Non refundable fare
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NonRefundableFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:Amount" name="Amount"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" name="override"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NonRefundableFare implements Serializable
    {
        private Amount amount;
        private Boolean override;

        /** 
         * Get the 'Amount' element value. Ref:DM0Z_C0_NRAA
         * 
         * @return value
         */
        public Amount getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Ref:DM0Z_C0_NRAA
         * 
         * @param amount
         */
        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'override' attribute value. Override Applied
        Ref: #DM0Z_C0_NRFO
         * 
         * @return value
         */
        public Boolean getOverride() {
            return override;
        }

        /** 
         * Set the 'override' attribute value. Override Applied
        Ref: #DM0Z_C0_NRFO
         * 
         * @param override
         */
        public void setOverride(Boolean override) {
            this.override = override;
        }
    }
}
