
package com.sabre.ns.ticketing.pqs;

import com.sabre.ns.ticketing.ttl.MiscMoneyWithCurrency;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.FareComponent">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComponent.SegNumber" name="FlightSegmentNumbers" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.FareDirectionality" name="FareDirectionality" minOccurs="0"/>
 *     &lt;xs:element type="ns:Details.OrigDest" name="Departure" minOccurs="0"/>
 *     &lt;xs:element type="ns:Details.OrigDest" name="Arrival" minOccurs="0"/>
 *     &lt;xs:element type="ns1:Misc.MoneyWithCurrency" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComponent.GoverningCarrier" name="GoverningCarrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComponent.RetailerRuleQualifier" name="RetailerRuleQualifier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CorpIdOrAcctCd" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComponent.BrandInfo" name="BrandInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.FareRules" name="Rules" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Discount" name="Discount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:anySimpleType" name="type"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="typeBitmap"/>
 *   &lt;xs:attribute type="xs:int" name="number"/>
 *   &lt;xs:attribute type="xs:string" name="fareBasisCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsFareComponent implements Serializable
{
    private PriceQuoteDetailsFareComponentSegNumber flightSegmentNumbers;
    private PriceQuoteFareDirectionality fareDirectionality;
    private DetailsOrigDest departure;
    private DetailsOrigDest arrival;
    private MiscMoneyWithCurrency amount;
    private PriceQuoteDetailsFareComponentGoverningCarrier governingCarrier;
    private List<String> ticketDesignatorList = new ArrayList<String>();
    private PriceQuoteDetailsFareComponentRetailerRuleQualifier retailerRuleQualifier;
    private String corpIdOrAcctCd;
    private PriceQuoteDetailsFareComponentBrandInfo brandInfo;
    private PriceQuoteFareRules rules;
    private AmountDiscount discount;
    private String type;
    private String typeBitmap;
    private Integer number;
    private String fareBasisCode;

    /** 
     * Get the 'FlightSegmentNumbers' element value. Display flight segments number covered by this particular fare component.

    					Ref: DM0Z_70_SEGN
     * 
     * @return value
     */
    public PriceQuoteDetailsFareComponentSegNumber getFlightSegmentNumbers() {
        return flightSegmentNumbers;
    }

    /** 
     * Set the 'FlightSegmentNumbers' element value. Display flight segments number covered by this particular fare component.

    					Ref: DM0Z_70_SEGN
     * 
     * @param flightSegmentNumbers
     */
    public void setFlightSegmentNumbers(
            PriceQuoteDetailsFareComponentSegNumber flightSegmentNumbers) {
        this.flightSegmentNumbers = flightSegmentNumbers;
    }

    /** 
     * Get the 'FareDirectionality' element value. Directionality of the fare Possible values:
    					Round trip
    					One way
    					One way directional
    					Inbound
    					Ref: DM0Z_75_IND1
     * 
     * @return value
     */
    public PriceQuoteFareDirectionality getFareDirectionality() {
        return fareDirectionality;
    }

    /** 
     * Set the 'FareDirectionality' element value. Directionality of the fare Possible values:
    					Round trip
    					One way
    					One way directional
    					Inbound
    					Ref: DM0Z_75_IND1
     * 
     * @param fareDirectionality
     */
    public void setFareDirectionality(
            PriceQuoteFareDirectionality fareDirectionality) {
        this.fareDirectionality = fareDirectionality;
    }

    /** 
     * Get the 'Departure' element value. Ref: DM0Z_75_1CTY
     * 
     * @return value
     */
    public DetailsOrigDest getDeparture() {
        return departure;
    }

    /** 
     * Set the 'Departure' element value. Ref: DM0Z_75_1CTY
     * 
     * @param departure
     */
    public void setDeparture(DetailsOrigDest departure) {
        this.departure = departure;
    }

    /** 
     * Get the 'Arrival' element value. Ref: DM0Z_75_2CTY
     * 
     * @return value
     */
    public DetailsOrigDest getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value. Ref: DM0Z_75_2CTY
     * 
     * @param arrival
     */
    public void setArrival(DetailsOrigDest arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'Amount' element value. Return NUC amount for particular Fare Component

    					Ref:  DM0Z_75_FAMT
     * 
     * @return value
     */
    public MiscMoneyWithCurrency getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Return NUC amount for particular Fare Component

    					Ref:  DM0Z_75_FAMT
     * 
     * @param amount
     */
    public void setAmount(MiscMoneyWithCurrency amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'GoverningCarrier' element value. Return Governing Carrier Code
    					Ref: DM0Z_75_GCR1
     * 
     * @return value
     */
    public PriceQuoteDetailsFareComponentGoverningCarrier getGoverningCarrier() {
        return governingCarrier;
    }

    /** 
     * Set the 'GoverningCarrier' element value. Return Governing Carrier Code
    					Ref: DM0Z_75_GCR1
     * 
     * @param governingCarrier
     */
    public void setGoverningCarrier(
            PriceQuoteDetailsFareComponentGoverningCarrier governingCarrier) {
        this.governingCarrier = governingCarrier;
    }

    /** 
     * Get the list of 'TicketDesignator' element items. Return Ticket Designator Code attached to Fare Basis Code

    					Ref: DM0Z_75_TDSG
     * 
     * @return list
     */
    public List<String> getTicketDesignatorList() {
        return ticketDesignatorList;
    }

    /** 
     * Set the list of 'TicketDesignator' element items. Return Ticket Designator Code attached to Fare Basis Code

    					Ref: DM0Z_75_TDSG
     * 
     * @param list
     */
    public void setTicketDesignatorList(List<String> list) {
        ticketDesignatorList = list;
    }

    /** 
     * Get the 'RetailerRuleQualifier' element value. Qualifier used across fare quote, pricing, shopping and ticketing.

    					Ref: DM0Z_76_TIDX x'C4
    					DM0Z_76_RC1
     * 
     * @return value
     */
    public PriceQuoteDetailsFareComponentRetailerRuleQualifier getRetailerRuleQualifier() {
        return retailerRuleQualifier;
    }

    /** 
     * Set the 'RetailerRuleQualifier' element value. Qualifier used across fare quote, pricing, shopping and ticketing.

    					Ref: DM0Z_76_TIDX x'C4
    					DM0Z_76_RC1
     * 
     * @param retailerRuleQualifier
     */
    public void setRetailerRuleQualifier(
            PriceQuoteDetailsFareComponentRetailerRuleQualifier retailerRuleQualifier) {
        this.retailerRuleQualifier = retailerRuleQualifier;
    }

    /** 
     * Get the 'CorpIdOrAcctCd' element value. Ref: DM0Z_75_CRID
    				
     * 
     * @return value
     */
    public String getCorpIdOrAcctCd() {
        return corpIdOrAcctCd;
    }

    /** 
     * Set the 'CorpIdOrAcctCd' element value. Ref: DM0Z_75_CRID
    				
     * 
     * @param corpIdOrAcctCd
     */
    public void setCorpIdOrAcctCd(String corpIdOrAcctCd) {
        this.corpIdOrAcctCd = corpIdOrAcctCd;
    }

    /** 
     * Get the 'BrandInfo' element value. Brand information at the fare component level

    					Ref: DM0Z_76_BR
    				
     * 
     * @return value
     */
    public PriceQuoteDetailsFareComponentBrandInfo getBrandInfo() {
        return brandInfo;
    }

    /** 
     * Set the 'BrandInfo' element value. Brand information at the fare component level

    					Ref: DM0Z_76_BR
    				
     * 
     * @param brandInfo
     */
    public void setBrandInfo(PriceQuoteDetailsFareComponentBrandInfo brandInfo) {
        this.brandInfo = brandInfo;
    }

    /** 
     * Get the 'Rules' element value. Fare Rules
     * 
     * @return value
     */
    public PriceQuoteFareRules getRules() {
        return rules;
    }

    /** 
     * Set the 'Rules' element value. Fare Rules
     * 
     * @param rules
     */
    public void setRules(PriceQuoteFareRules rules) {
        this.rules = rules;
    }

    /** 
     * Get the 'Discount' element value. Discount applied
     * 
     * @return value
     */
    public AmountDiscount getDiscount() {
        return discount;
    }

    /** 
     * Set the 'Discount' element value. Discount applied
     * 
     * @param discount
     */
    public void setDiscount(AmountDiscount discount) {
        this.discount = discount;
    }

    /** 
     * Get the 'type' attribute value. Fare Type
    Ref: DM0Z_75_FATP
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Fare Type
    Ref: DM0Z_75_FATP
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'typeBitmap' attribute value. Fare Type Bitmap
    Ref: DM0Z_75_FATY
     * 
     * @return value
     */
    public String getTypeBitmap() {
        return typeBitmap;
    }

    /** 
     * Set the 'typeBitmap' attribute value. Fare Type Bitmap
    Ref: DM0Z_75_FATY
     * 
     * @param typeBitmap
     */
    public void setTypeBitmap(String typeBitmap) {
        this.typeBitmap = typeBitmap;
    }

    /** 
     * Get the 'number' attribute value. Display number of fare component stored in PQ
    				Ref: DM0Z_75_FCNR
     * 
     * @return value
     */
    public Integer getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. Display number of fare component stored in PQ
    				Ref: DM0Z_75_FCNR
     * 
     * @param number
     */
    public void setNumber(Integer number) {
        this.number = number;
    }

    /** 
     * Get the 'fareBasisCode' attribute value. Fare Basis Code for particular Fare Component

    				Ref: DM0Z_75_FBCD
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'fareBasisCode' attribute value. Fare Basis Code for particular Fare Component

    				Ref: DM0Z_75_FBCD
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }
}
