
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.HistoryInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.History.AgentInfo" name="AgentInfo"/>
 *     &lt;xs:element type="ns:PriceQuote.History.TransactionInfo" name="TransactionInfo"/>
 *     &lt;xs:element type="ns:PriceQuote.History.ModificationDetails" name="ModificationDetails" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="sequence"/>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsHistoryInfo implements Serializable
{
    private PriceQuoteHistoryAgentInfo agentInfo;
    private PriceQuoteHistoryTransactionInfo transactionInfo;
    private PriceQuoteHistoryModificationDetails modificationDetails;
    private BigInteger sequence;
    private String type;

    /** 
     * Get the 'AgentInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteHistoryAgentInfo getAgentInfo() {
        return agentInfo;
    }

    /** 
     * Set the 'AgentInfo' element value.
     * 
     * @param agentInfo
     */
    public void setAgentInfo(PriceQuoteHistoryAgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    /** 
     * Get the 'TransactionInfo' element value. Historical data at PQ transaction
    					level
     * 
     * @return value
     */
    public PriceQuoteHistoryTransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value. Historical data at PQ transaction
    					level
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(
            PriceQuoteHistoryTransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the 'ModificationDetails' element value. Details of the updates made to the price quote.
    				
     * 
     * @return value
     */
    public PriceQuoteHistoryModificationDetails getModificationDetails() {
        return modificationDetails;
    }

    /** 
     * Set the 'ModificationDetails' element value. Details of the updates made to the price quote.
    				
     * 
     * @param modificationDetails
     */
    public void setModificationDetails(
            PriceQuoteHistoryModificationDetails modificationDetails) {
        this.modificationDetails = modificationDetails;
    }

    /** 
     * Get the 'sequence' attribute value.
     * 
     * @return value
     */
    public BigInteger getSequence() {
        return sequence;
    }

    /** 
     * Set the 'sequence' attribute value.
     * 
     * @param sequence
     */
    public void setSequence(BigInteger sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'type' attribute value. History type

    				Possible values:
    				Create
    				Update
    				Delete
    			
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. History type

    				Possible values:
    				Create
    				Update
    				Delete
    			
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
}
