
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.MessageInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Message.TextType" name="Message" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Message.EndorsementType" name="Remarks" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PricingParameters" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ManualInputMessage" minOccurs="0"/>
 *     &lt;xs:element name="BaggageDisclosure" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class BaggageDisclosure -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsMessageInfo implements Serializable
{
    private List<MessageTextType> messageList = new ArrayList<MessageTextType>();
    private List<MessageEndorsementType> remarkList = new ArrayList<MessageEndorsementType>();
    private String pricingParameters;
    private String manualInputMessage;
    private List<BaggageDisclosure> baggageDisclosureList = new ArrayList<BaggageDisclosure>();

    /** 
     * Get the list of 'Message' element items.
     * 
     * @return list
     */
    public List<MessageTextType> getMessageList() {
        return messageList;
    }

    /** 
     * Set the list of 'Message' element items.
     * 
     * @param list
     */
    public void setMessageList(List<MessageTextType> list) {
        messageList = list;
    }

    /** 
     * Get the list of 'Remarks' element items. Remarks applicable on the ticket display
    				
     * 
     * @return list
     */
    public List<MessageEndorsementType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remarks' element items. Remarks applicable on the ticket display
    				
     * 
     * @param list
     */
    public void setRemarkList(List<MessageEndorsementType> list) {
        remarkList = list;
    }

    /** 
     * Get the 'PricingParameters' element value. Pricing parameter used to price PQ
    					Ref: DM0Z_60_TYPE
    					#DM0Z_60_PRI
     * 
     * @return value
     */
    public String getPricingParameters() {
        return pricingParameters;
    }

    /** 
     * Set the 'PricingParameters' element value. Pricing parameter used to price PQ
    					Ref: DM0Z_60_TYPE
    					#DM0Z_60_PRI
     * 
     * @param pricingParameters
     */
    public void setPricingParameters(String pricingParameters) {
        this.pricingParameters = pricingParameters;
    }

    /** 
     * Get the 'ManualInputMessage' element value. Manual input free Text
    					Ref: DM0Z_60_TYPE
    					#DM0Z_60_MAN 
     * 
     * @return value
     */
    public String getManualInputMessage() {
        return manualInputMessage;
    }

    /** 
     * Set the 'ManualInputMessage' element value. Manual input free Text
    					Ref: DM0Z_60_TYPE
    					#DM0Z_60_MAN 
     * 
     * @param manualInputMessage
     */
    public void setManualInputMessage(String manualInputMessage) {
        this.manualInputMessage = manualInputMessage;
    }

    /** 
     * Get the list of 'BaggageDisclosure' element items.
     * 
     * @return list
     */
    public List<BaggageDisclosure> getBaggageDisclosureList() {
        return baggageDisclosureList;
    }

    /** 
     * Set the list of 'BaggageDisclosure' element items.
     * 
     * @param list
     */
    public void setBaggageDisclosureList(List<BaggageDisclosure> list) {
        baggageDisclosureList = list;
    }
    /** 
     * Baggage disclosure free text
    					Ref: DM0Z_60_TYPE
    					#DM0Z_60_BAG
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDisclosure" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="type"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BaggageDisclosure implements Serializable
    {
        private String string;
        private String type;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'type' attribute value. Type of Baggage Allowance  / disclosure at PQ level.
        									Ref: DM0Z_60_TYPB
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Type of Baggage Allowance  / disclosure at PQ level.
        									Ref: DM0Z_60_TYPB
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }
    }
}
