
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.MiscellaneousInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="AlternateValidatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Identifier.TourType" name="TourNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CorpIdOrAcctCd" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="xs:string" name="JourneyType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="HemisphereOrDestCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:KeyValuePair" name="MiscellaneousData" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsMiscellaneousInfo implements Serializable
{
    private List<String> validatingCarrierList = new ArrayList<String>();
    private List<String> alternateValidatingCarrierList = new ArrayList<String>();
    private IdentifierTourType tourNumber;
    private String itineraryType;
    private List<String> corpIdOrAcctCdList = new ArrayList<String>();
    private String journeyType;
    private String hemisphereOrDestCode;
    private List<KeyValuePair> miscellaneousDataList = new ArrayList<KeyValuePair>();

    /** 
     * Get the list of 'ValidatingCarrier' element items. Validating Carrier.
    					Ref: DM0Z_65_CRXC
     * 
     * @return list
     */
    public List<String> getValidatingCarrierList() {
        return validatingCarrierList;
    }

    /** 
     * Set the list of 'ValidatingCarrier' element items. Validating Carrier.
    					Ref: DM0Z_65_CRXC
     * 
     * @param list
     */
    public void setValidatingCarrierList(List<String> list) {
        validatingCarrierList = list;
    }

    /** 
     * Get the list of 'AlternateValidatingCarrier' element items. Ref: DM0Z_E9_VLC_CXR
     * 
     * @return list
     */
    public List<String> getAlternateValidatingCarrierList() {
        return alternateValidatingCarrierList;
    }

    /** 
     * Set the list of 'AlternateValidatingCarrier' element items. Ref: DM0Z_E9_VLC_CXR
     * 
     * @param list
     */
    public void setAlternateValidatingCarrierList(List<String> list) {
        alternateValidatingCarrierList = list;
    }

    /** 
     * Get the 'TourNumber' element value.
     * 
     * @return value
     */
    public IdentifierTourType getTourNumber() {
        return tourNumber;
    }

    /** 
     * Set the 'TourNumber' element value.
     * 
     * @param tourNumber
     */
    public void setTourNumber(IdentifierTourType tourNumber) {
        this.tourNumber = tourNumber;
    }

    /** 
     * Get the 'ItineraryType' element value. Possible values
    					I - International
    					D- Domestic
    					Ref:DM0Z_65_ID01
     * 
     * @return value
     */
    public String getItineraryType() {
        return itineraryType;
    }

    /** 
     * Set the 'ItineraryType' element value. Possible values
    					I - International
    					D- Domestic
    					Ref:DM0Z_65_ID01
     * 
     * @param itineraryType
     */
    public void setItineraryType(String itineraryType) {
        this.itineraryType = itineraryType;
    }

    /** 
     * Get the list of 'CorpIdOrAcctCd' element items. Ref: DM0Z_66_CORP
    				
     * 
     * @return list
     */
    public List<String> getCorpIdOrAcctCdList() {
        return corpIdOrAcctCdList;
    }

    /** 
     * Set the list of 'CorpIdOrAcctCd' element items. Ref: DM0Z_66_CORP
    				
     * 
     * @param list
     */
    public void setCorpIdOrAcctCdList(List<String> list) {
        corpIdOrAcctCdList = list;
    }

    /** 
     * Get the 'JourneyType' element value. ref:DM0Z_65_TKCT
    					Possible values:
    					Business
    					Pleasure
    					Selected Charters
     * 
     * @return value
     */
    public String getJourneyType() {
        return journeyType;
    }

    /** 
     * Set the 'JourneyType' element value. ref:DM0Z_65_TKCT
    					Possible values:
    					Business
    					Pleasure
    					Selected Charters
     * 
     * @param journeyType
     */
    public void setJourneyType(String journeyType) {
        this.journeyType = journeyType;
    }

    /** 
     * Get the 'HemisphereOrDestCode' element value. ref:DM0Z_65_TKCD
    					Client Destination - continents
     * 
     * @return value
     */
    public String getHemisphereOrDestCode() {
        return hemisphereOrDestCode;
    }

    /** 
     * Set the 'HemisphereOrDestCode' element value. ref:DM0Z_65_TKCD
    					Client Destination - continents
     * 
     * @param hemisphereOrDestCode
     */
    public void setHemisphereOrDestCode(String hemisphereOrDestCode) {
        this.hemisphereOrDestCode = hemisphereOrDestCode;
    }

    /** 
     * Get the list of 'MiscellaneousData' element items. Key value pair for Miscellaneous Data
     * 
     * @return list
     */
    public List<KeyValuePair> getMiscellaneousDataList() {
        return miscellaneousDataList;
    }

    /** 
     * Set the list of 'MiscellaneousData' element items. Key value pair for Miscellaneous Data
     * 
     * @param list
     */
    public void setMiscellaneousDataList(List<KeyValuePair> list) {
        miscellaneousDataList = list;
    }
}
