
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.NetRemitInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Fare.BasicInfo" name="NetFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.BasicInfo" name="SellingFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="Discount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="method"/>
 *   &lt;xs:attribute type="xs:string" name="valueCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsNetRemitInfo implements Serializable
{
    private FareBasicInfo netFare;
    private FareBasicInfo sellingFare;
    private Amount discount;
    private String method;
    private String valueCode;

    /** 
     * Get the 'NetFare' element value. Net fare details
    					Ref: DM0Z_E8_NET...
     * 
     * @return value
     */
    public FareBasicInfo getNetFare() {
        return netFare;
    }

    /** 
     * Set the 'NetFare' element value. Net fare details
    					Ref: DM0Z_E8_NET...
     * 
     * @param netFare
     */
    public void setNetFare(FareBasicInfo netFare) {
        this.netFare = netFare;
    }

    /** 
     * Get the 'SellingFare' element value. Selling fare details
    					Ref: DM0Z_E8_SEL_...
     * 
     * @return value
     */
    public FareBasicInfo getSellingFare() {
        return sellingFare;
    }

    /** 
     * Set the 'SellingFare' element value. Selling fare details
    					Ref: DM0Z_E8_SEL_...
     * 
     * @param sellingFare
     */
    public void setSellingFare(FareBasicInfo sellingFare) {
        this.sellingFare = sellingFare;
    }

    /** 
     * Get the 'Discount' element value. Discount Amount if applicable
    					Ref: DM0Z_E8_DISCOUNT
     * 
     * @return value
     */
    public Amount getDiscount() {
        return discount;
    }

    /** 
     * Set the 'Discount' element value. Discount Amount if applicable
    					Ref: DM0Z_E8_DISCOUNT
     * 
     * @param discount
     */
    public void setDiscount(Amount discount) {
        this.discount = discount;
    }

    /** 
     * Get the 'method' attribute value. CAT35 Method Type
    				Ref: DM0Z_E8_RMT_TYPE
     * 
     * @return value
     */
    public String getMethod() {
        return method;
    }

    /** 
     * Set the 'method' attribute value. CAT35 Method Type
    				Ref: DM0Z_E8_RMT_TYPE
     * 
     * @param method
     */
    public void setMethod(String method) {
        this.method = method;
    }

    /** 
     * Get the 'valueCode' attribute value. CAT35 Net Remit Value Code
    				Ref: DM0Z_E8_REMT_CDE
     * 
     * @return value
     */
    public String getValueCode() {
        return valueCode;
    }

    /** 
     * Set the 'valueCode' attribute value. CAT35 Net Remit Value Code
    				Ref: DM0Z_E8_REMT_CDE
     * 
     * @param valueCode
     */
    public void setValueCode(String valueCode) {
        this.valueCode = valueCode;
    }
}
