
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.RefundInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="TotalRefund"/>
 *     &lt;xs:element type="ns:Amount" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element name="NetRemit" minOccurs="0">
 *       &lt;!-- Reference to inner class NetRemit -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:RefundFare.CommissionDetails" name="Commission" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="ns:RefundFare.TaxInfo" name="TaxInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FareCalculationType" name="FareCalculation" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="WaiverCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsRefundInfo implements Serializable
{
    private Amount totalRefund;
    private Amount baseFare;
    private Amount equivalentFare;
    private Amount totalTax;
    private NetRemit netRemit;
    private List<RefundFareCommissionDetails> commissionList = new ArrayList<RefundFareCommissionDetails>();
    private RefundFareTaxInfo taxInfo;
    private FareCalculationType fareCalculation;
    private String waiverCode;

    /** 
     * Get the 'TotalRefund' element value. Exchange Amount
    Ref: DM0Z_36_TAMT
    Ref: DM0Z_38_BCAM
     * 
     * @return value
     */
    public Amount getTotalRefund() {
        return totalRefund;
    }

    /** 
     * Set the 'TotalRefund' element value. Exchange Amount
    Ref: DM0Z_36_TAMT
    Ref: DM0Z_38_BCAM
     * 
     * @param totalRefund
     */
    public void setTotalRefund(Amount totalRefund) {
        this.totalRefund = totalRefund;
    }

    /** 
     * Get the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_84_BFAR		
     * 
     * @return value
     */
    public Amount getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_84_BFAR		
     * 
     * @param baseFare
     */
    public void setBaseFare(Amount baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_84_EFAR
     * 
     * @return value
     */
    public Amount getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_84_EFAR
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(Amount equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_84_TTAC		
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_84_TTAC		
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'NetRemit' element value.
     * 
     * @return value
     */
    public NetRemit getNetRemit() {
        return netRemit;
    }

    /** 
     * Set the 'NetRemit' element value.
     * 
     * @param netRemit
     */
    public void setNetRemit(NetRemit netRemit) {
        this.netRemit = netRemit;
    }

    /** 
     * Get the list of 'Commission' element items. Commission at Farelevel
     * 
     * @return list
     */
    public List<RefundFareCommissionDetails> getCommissionList() {
        return commissionList;
    }

    /** 
     * Set the list of 'Commission' element items. Commission at Farelevel
     * 
     * @param list
     */
    public void setCommissionList(List<RefundFareCommissionDetails> list) {
        commissionList = list;
    }

    /** 
     * Get the 'TaxInfo' element value.
     * 
     * @return value
     */
    public RefundFareTaxInfo getTaxInfo() {
        return taxInfo;
    }

    /** 
     * Set the 'TaxInfo' element value.
     * 
     * @param taxInfo
     */
    public void setTaxInfo(RefundFareTaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    /** 
     * Get the 'FareCalculation' element value. FareCalc line free Text
    					Ref: DM0Z_A5_DATA
     * 
     * @return value
     */
    public FareCalculationType getFareCalculation() {
        return fareCalculation;
    }

    /** 
     * Set the 'FareCalculation' element value. FareCalc line free Text
    					Ref: DM0Z_A5_DATA
     * 
     * @param fareCalculation
     */
    public void setFareCalculation(FareCalculationType fareCalculation) {
        this.fareCalculation = fareCalculation;
    }

    /** 
     * Get the 'WaiverCode' element value. ref:DM0Z_D8_QWCB
     * 
     * @return value
     */
    public String getWaiverCode() {
        return waiverCode;
    }

    /** 
     * Set the 'WaiverCode' element value. ref:DM0Z_D8_QWCB
     * 
     * @param waiverCode
     */
    public void setWaiverCode(String waiverCode) {
        this.waiverCode = waiverCode;
    }
    /** 
     * Net Remit applied
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:Amount" name="NetFare" minOccurs="0"/>
     *       &lt;xs:element type="ns:Amount" name="NetFareUsed" minOccurs="0"/>
     *       &lt;xs:element type="ns:Amount" name="SellingFare" minOccurs="0"/>
     *       &lt;xs:element type="ns:Amount" name="RefundToCC" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NetRemit implements Serializable
    {
        private Amount netFare;
        private Amount netFareUsed;
        private Amount sellingFare;
        private Amount refundToCC;

        /** 
         * Get the 'NetFare' element value. Ref: DM0Z_D8_NFARXC
         * 
         * @return value
         */
        public Amount getNetFare() {
            return netFare;
        }

        /** 
         * Set the 'NetFare' element value. Ref: DM0Z_D8_NFARXC
         * 
         * @param netFare
         */
        public void setNetFare(Amount netFare) {
            this.netFare = netFare;
        }

        /** 
         * Get the 'NetFareUsed' element value. Ref: DM0Z_D8_NFUXC
         * 
         * @return value
         */
        public Amount getNetFareUsed() {
            return netFareUsed;
        }

        /** 
         * Set the 'NetFareUsed' element value. Ref: DM0Z_D8_NFUXC
         * 
         * @param netFareUsed
         */
        public void setNetFareUsed(Amount netFareUsed) {
            this.netFareUsed = netFareUsed;
        }

        /** 
         * Get the 'SellingFare' element value. Ref: DM0Z_D8_SFARXC
         * 
         * @return value
         */
        public Amount getSellingFare() {
            return sellingFare;
        }

        /** 
         * Set the 'SellingFare' element value. Ref: DM0Z_D8_SFARXC
         * 
         * @param sellingFare
         */
        public void setSellingFare(Amount sellingFare) {
            this.sellingFare = sellingFare;
        }

        /** 
         * Get the 'RefundToCC' element value. Ref: DM0Z_D8_NCCAXC
         * 
         * @return value
         */
        public Amount getRefundToCC() {
            return refundToCC;
        }

        /** 
         * Set the 'RefundToCC' element value. Ref: DM0Z_D8_NCCAXC
         * 
         * @param refundToCC
         */
        public void setRefundToCC(Amount refundToCC) {
            this.refundToCC = refundToCC;
        }
    }
}
