
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.ResidualInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="TotalAmount" minOccurs="0"/>
 *     &lt;xs:element type="ns:Residual.RefundableAmount" name="RefundableDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="ForfeitedAmount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsResidualInfo implements Serializable
{
    private Amount totalAmount;
    private ResidualRefundableAmount refundableDetails;
    private Amount forfeitedAmount;

    /** 
     * Get the 'TotalAmount' element value. Residual applied to penalty per rule
     * 
     * @return value
     */
    public Amount getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Residual applied to penalty per rule
     * 
     * @param totalAmount
     */
    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    /** 
     * Get the 'RefundableDetails' element value. Refundable Amount
     * 
     * @return value
     */
    public ResidualRefundableAmount getRefundableDetails() {
        return refundableDetails;
    }

    /** 
     * Set the 'RefundableDetails' element value. Refundable Amount
     * 
     * @param refundableDetails
     */
    public void setRefundableDetails(ResidualRefundableAmount refundableDetails) {
        this.refundableDetails = refundableDetails;
    }

    /** 
     * Get the 'ForfeitedAmount' element value. Forfeited amount
     * 
     * @return value
     */
    public Amount getForfeitedAmount() {
        return forfeitedAmount;
    }

    /** 
     * Set the 'ForfeitedAmount' element value. Forfeited amount
     * 
     * @param forfeitedAmount
     */
    public void setForfeitedAmount(Amount forfeitedAmount) {
        this.forfeitedAmount = forfeitedAmount;
    }
}
