
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.RetailerFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.OtherCommission" name="Commission" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.HandlingFee" name="HandlingFee" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Fare.AdjustedAmount" name="AdjustedAmount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsRetailerFareInfo implements Serializable
{
    private Amount baseFare;
    private Amount equivalentFare;
    private Amount totalTax;
    private Amount totalFare;
    private FareOtherCommission commission;
    private FareTaxInfo taxInfo;
    private List<FareHandlingFee> handlingFeeList = new ArrayList<FareHandlingFee>();
    private PriceQuoteFareAdjustedAmount adjustedAmount;

    /** 
     * Get the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_85_BFAR
    					DM0Z_CA_BFAR
    				
     * 
     * @return value
     */
    public Amount getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_85_BFAR
    					DM0Z_CA_BFAR
    				
     * 
     * @param baseFare
     */
    public void setBaseFare(Amount baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_85_EFAR
    					DM0Z_CA_EFAR
     * 
     * @return value
     */
    public Amount getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_85_EFAR
    					DM0Z_CA_EFAR
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(Amount equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_85_TTAC
    					DM0Z_CA_TTAC	
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_85_TTAC
    					DM0Z_CA_TTAC	
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
    					Ref: DM0Z_85_TFAR
    					DM0Z_CA_TFAR		
     * 
     * @return value
     */
    public Amount getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
    					Ref: DM0Z_85_TFAR
    					DM0Z_CA_TFAR		
     * 
     * @param totalFare
     */
    public void setTotalFare(Amount totalFare) {
        this.totalFare = totalFare;
    }

    /** 
     * Get the 'Commission' element value.
     * 
     * @return value
     */
    public FareOtherCommission getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value.
     * 
     * @param commission
     */
    public void setCommission(FareOtherCommission commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'TaxInfo' element value.
     * 
     * @return value
     */
    public FareTaxInfo getTaxInfo() {
        return taxInfo;
    }

    /** 
     * Set the 'TaxInfo' element value.
     * 
     * @param taxInfo
     */
    public void setTaxInfo(FareTaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    /** 
     * Get the list of 'HandlingFee' element items.
     * 
     * @return list
     */
    public List<FareHandlingFee> getHandlingFeeList() {
        return handlingFeeList;
    }

    /** 
     * Set the list of 'HandlingFee' element items.
     * 
     * @param list
     */
    public void setHandlingFeeList(List<FareHandlingFee> list) {
        handlingFeeList = list;
    }

    /** 
     * Get the 'AdjustedAmount' element value. The amount by which the retailer selling fare was adjusted
     * 
     * @return value
     */
    public PriceQuoteFareAdjustedAmount getAdjustedAmount() {
        return adjustedAmount;
    }

    /** 
     * Set the 'AdjustedAmount' element value. The amount by which the retailer selling fare was adjusted
     * 
     * @param adjustedAmount
     */
    public void setAdjustedAmount(PriceQuoteFareAdjustedAmount adjustedAmount) {
        this.adjustedAmount = adjustedAmount;
    }
}
